/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.reader;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.reader.DeployitJarManifest;
import com.xebialabs.deployit.service.importer.reader.ManifestEntry;
import com.xebialabs.overthere.local.LocalFile;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployableConfigurationItemReader {
    static final String NAMESPACE_SEPARATOR = "/";
    static final String CI = "CI-";
    static final String TYPE_ATTRIBUTE_NAME = "CI-Type";
    static final String NAME_ATTRIBUTE_NAME = "CI-Name";
    private final DeployitJarManifest manifest;
    private static final Logger logger = LoggerFactory.getLogger(DeployableConfigurationItemReader.class);

    public DeployableConfigurationItemReader(DeployitJarManifest manifest) {
        this.manifest = manifest;
    }

    public Deployable readMiddlewareConfiguration(DeploymentPackage deploymentPackage, ManifestEntry entry) {
        String configurationItemType = DeployableConfigurationItemReader.readCIType(entry);
        Descriptor descriptor = DeployableConfigurationItemReader.getDescriptorForConfigurationItem(entry.getName(), configurationItemType);
        Deployable configurationItem = (Deployable)descriptor.newInstance();
        String baseId = deploymentPackage.getId();
        configurationItem.setId(baseId + NAMESPACE_SEPARATOR + DeployableConfigurationItemReader.getDeployableNameFromEntryName(entry.getName()));
        this.fillAttributes(configurationItem, descriptor, entry, baseId);
        return configurationItem;
    }

    public boolean isMiddlewareResource(ManifestEntry entry) {
        String configurationItemType = entry.getValue(TYPE_ATTRIBUTE_NAME);
        if (DeployableConfigurationItemReader.isBlank(configurationItemType)) {
            return false;
        }
        Descriptor configurationItemDescriptor = DeployableConfigurationItemReader.getDescriptorForConfigurationItem(entry.getName(), configurationItemType);
        Checks.checkArgument(configurationItemDescriptor.isAssignableTo(Deployable.class), "Configuration item %s of type %s is not Deployable", entry.getName(), configurationItemType);
        return !configurationItemDescriptor.isAssignableTo(DeployableArtifact.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeployableArtifact readArtifact(DeploymentPackage deploymentPackage, ImportSource source, ManifestEntry entry, ImportingContext ctx) {
        String configurationItemType = DeployableConfigurationItemReader.readCIType(entry);
        Descriptor descriptor = DeployableConfigurationItemReader.getDescriptorForConfigurationItem(entry.getName(), configurationItemType);
        DeployableArtifact artifact = (DeployableArtifact)descriptor.newInstance();
        String baseId = deploymentPackage.getId();
        artifact.setId(baseId + NAMESPACE_SEPARATOR + DeployableConfigurationItemReader.getDeployableName(entry));
        TFile sourceArchive = new TFile(source.getFile());
        try {
            TFile tempFolder = DeployableConfigurationItemReader.createTempFolderForImport(ctx, (Artifact)artifact);
            TFile dest = DeployableConfigurationItemReader.copyArtifactData(sourceArchive, entry.getName(), tempFolder, artifact, baseId);
            logger.debug("Adding {} {} to deployment package", (Object)descriptor.getType(), (Object)dest);
            artifact.setFile(LocalFile.valueOf((File)dest.getFile()));
            this.fillAttributes((Deployable)artifact, descriptor, entry, baseId);
            DeployableArtifact deployableArtifact = artifact;
            return deployableArtifact;
        }
        finally {
            if (sourceArchive.isArchive()) {
                try {
                    TFile.umount((TFile)sourceArchive);
                }
                catch (FsSyncException e) {
                    logger.error("Unable to release resources for archive {}", (Object)sourceArchive.getName());
                    logger.error("Following exception occurred while trying to release resources: {}", (Object)e.getMessage());
                }
            }
        }
    }

    private static TFile copyArtifactData(TFile sourceArchive, String entryName, TFile tempFolder, DeployableArtifact artifact, String baseId) {
        TFile artifactFile = new TFile((File)sourceArchive, entryName, TArchiveDetector.NULL);
        if (!artifactFile.exists()) {
            throw new RuntimeIOException(String.format("The entry %s could not be found in the importable package %s.", entryName, baseId));
        }
        TFile dest = new TFile((File)tempFolder, artifactFile.getName());
        try {
            artifactFile.cp_r((File)dest);
        }
        catch (IOException e) {
            throw new RuntimeIOException(String.format("Could not copy %s to %s while importing %s", artifactFile, dest, artifact.getId()), e);
        }
        return dest;
    }

    private static TFile createTempFolderForImport(ImportingContext ctx, Artifact artifact) {
        try {
            String name = "temp-" + artifact.getName();
            TFile tempFolder = new TFile(File.createTempFile(name, "")).rm().mkdir(false);
            ((List)ctx.getAttribute("temporaryFiles")).add(tempFolder);
            logger.debug("Created Temporary folder {}", (Object)tempFolder);
            return tempFolder;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private static String getDeployableName(ManifestEntry entry) {
        String name = entry.getValue(NAME_ATTRIBUTE_NAME);
        if (name != null) {
            return name;
        }
        return DeployableConfigurationItemReader.getDeployableNameFromEntryName(entry.getName());
    }

    protected static String getDeployableNameFromEntryName(String entryName) {
        String name;
        int index = entryName.lastIndexOf(NAMESPACE_SEPARATOR);
        if (index > -1) {
            if (++index >= entryName.length()) {
                throw new ImporterException("Could not determine artifact Name: %s because entry ends with '/'", entryName);
            }
            name = entryName.substring(index);
        } else {
            name = entryName;
        }
        return name;
    }

    private static String readCIType(ManifestEntry entry) {
        return DeployableConfigurationItemReader.readCIType(entry, entry.getName());
    }

    private static String readCIType(ManifestEntry entry, String name) {
        String configurationItemTypeShortName = entry.getValue(TYPE_ATTRIBUTE_NAME);
        if (DeployableConfigurationItemReader.isBlank(configurationItemTypeShortName)) {
            throw new ImporterException("Could not import Name: %s because of missing %s entry in MANIFEST.MF", name, TYPE_ATTRIBUTE_NAME);
        }
        return configurationItemTypeShortName;
    }

    private static Descriptor getDescriptorForConfigurationItem(String entryName, String configurationItemTypeShortName) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((String)configurationItemTypeShortName);
        if (descriptor == null) {
            throw new ImporterException("Could not import Name: %s because %s is not a known CI type", entryName, configurationItemTypeShortName);
        }
        return descriptor;
    }

    private static boolean isBlank(String packageFormatVersion) {
        return Strings.nullToEmpty((String)packageFormatVersion).trim().isEmpty();
    }

    void fillAttributes(Deployable entity, Descriptor configurationItemDescriptor, ManifestEntry entry, String baseId) {
        block9: for (PropertyDescriptor propertyDescriptor : configurationItemDescriptor.getPropertyDescriptors()) {
            String name = propertyDescriptor.getName();
            switch (propertyDescriptor.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    String value = entry.getValue(CI + name);
                    propertyDescriptor.set((ConfigurationItem)entity, (Object)value);
                    continue block9;
                }
                case CI: {
                    String mfName = entry.getValue(CI + name);
                    if (mfName == null) continue block9;
                    Deployable configurationItem = this.convertReference(baseId, mfName);
                    propertyDescriptor.set((ConfigurationItem)entity, (Object)configurationItem);
                    continue block9;
                }
                case SET_OF_STRING: {
                    HashSet stringsSet = Sets.newHashSet(entry.getStrings(propertyDescriptor.getName()));
                    if (stringsSet.isEmpty()) continue block9;
                    propertyDescriptor.set((ConfigurationItem)entity, (Object)stringsSet);
                    continue block9;
                }
                case SET_OF_CI: {
                    HashSet setOfCis = Sets.newHashSet(this.transformCollectionOfCis(entry, baseId, propertyDescriptor));
                    if (setOfCis.isEmpty()) continue block9;
                    propertyDescriptor.set((ConfigurationItem)entity, (Object)setOfCis);
                    continue block9;
                }
                case LIST_OF_STRING: {
                    ArrayList stringsList = Lists.newArrayList(entry.getStrings(propertyDescriptor.getName()));
                    if (stringsList.isEmpty()) continue block9;
                    propertyDescriptor.set((ConfigurationItem)entity, (Object)stringsList);
                    continue block9;
                }
                case LIST_OF_CI: {
                    ArrayList listOfCis = Lists.newArrayList(this.transformCollectionOfCis(entry, baseId, propertyDescriptor));
                    if (listOfCis.isEmpty()) continue block9;
                    propertyDescriptor.set((ConfigurationItem)entity, (Object)listOfCis);
                    continue block9;
                }
                case MAP_STRING_STRING: {
                    Map<String, String> map = entry.getMap(propertyDescriptor.getName());
                    propertyDescriptor.set((ConfigurationItem)entity, map);
                    continue block9;
                }
            }
            throw new IllegalStateException("Should not end up here!");
        }
    }

    private Deployable convertReference(String baseId, String mfName) {
        ManifestEntry referencedAttrs = this.manifest.getEntry(mfName);
        if (referencedAttrs == null) {
            throw new ImporterException("Couldn't find the referenced entry [%s], are you using the entry Name?", mfName);
        }
        Type ciType = Type.valueOf((String)DeployableConfigurationItemReader.readCIType(referencedAttrs, mfName));
        Deployable configurationItem = (Deployable)ciType.getDescriptor().newInstance();
        String ciName = referencedAttrs.getValue(NAME_ATTRIBUTE_NAME);
        if (ciName == null) {
            ciName = mfName;
        }
        String id = IdGenerator.generateId((String)baseId, (String)ciName);
        configurationItem.setId(id);
        return configurationItem;
    }

    private Collection<Deployable> transformCollectionOfCis(ManifestEntry entry, final String baseId, PropertyDescriptor propertyDescriptor) {
        return Collections2.transform(entry.getStrings(propertyDescriptor.getName()), (Function)new Function<String, Deployable>(){

            public Deployable apply(String from) {
                return DeployableConfigurationItemReader.this.convertReference(baseId, from);
            }
        });
    }
}

