/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.crypto.CipherOutputStream;
import de.schlichtherle.truezip.crypto.param.AesKeyStrength;
import de.schlichtherle.truezip.io.LEDataOutputStream;
import de.schlichtherle.truezip.zip.WinZipAesCipher;
import de.schlichtherle.truezip.zip.WinZipAesEntryParameters;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import net.jcip.annotations.NotThreadSafe;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.io.MacOutputStream;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class WinZipAesEntryOutputStream
extends CipherOutputStream {
    static final int ITERATION_COUNT = 1000;
    static final int AES_BLOCK_SIZE_BITS = 128;
    static final int PWD_VERIFIER_BITS = 16;
    private final SecureRandom shaker = new SecureRandom();
    private final WinZipAesEntryParameters param;
    private Mac mac;
    private LEDataOutputStream dos;

    WinZipAesEntryOutputStream(LEDataOutputStream out, WinZipAesEntryParameters param) throws IOException {
        super((OutputStream)out, new BufferedBlockCipher((BlockCipher)new WinZipAesCipher()));
        assert (null != out);
        assert (null != param);
        this.param = param;
        AesKeyStrength keyStrength = param.getKeyStrength();
        int keyStrengthBits = keyStrength.getBits();
        int keyStrengthBytes = keyStrength.getBytes();
        byte[] salt = new byte[keyStrengthBytes / 2];
        this.shaker.nextBytes(salt);
        byte[] passwd = param.getWritePassword();
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator();
        gen.init(passwd, salt, 1000);
        assert (128 <= keyStrengthBits);
        KeyParameter keyParam = (KeyParameter)gen.generateDerivedParameters(2 * keyStrengthBits + 16);
        this.paranoidWipe(passwd);
        byte[] ctrIv = new byte[16];
        ParametersWithIV aesCtrParam = new ParametersWithIV((CipherParameters)new KeyParameter(keyParam.getKey(), 0, keyStrengthBytes), ctrIv);
        KeyParameter sha1HMacParam = new KeyParameter(keyParam.getKey(), keyStrengthBytes, keyStrengthBytes);
        BufferedBlockCipher cipher = this.cipher;
        cipher.init(true, (CipherParameters)aesCtrParam);
        this.mac = new HMac((Digest)new SHA1Digest());
        HMac mac = this.mac;
        mac.init((CipherParameters)sha1HMacParam);
        this.dos = (LEDataOutputStream)this.delegate;
        this.delegate = new MacOutputStream((OutputStream)this.dos, (Mac)mac);
        this.dos.write(salt);
        this.writePasswordVerifier(keyParam);
    }

    private void writePasswordVerifier(KeyParameter keyParam) throws IOException {
        this.dos.write(keyParam.getKey(), 2 * this.param.getKeyStrength().getBytes(), 2);
    }

    private void paranoidWipe(byte[] passwd) {
        this.shaker.nextBytes(passwd);
    }

    @Override
    protected void finish() throws IOException {
        super.finish();
        Mac mac = this.mac;
        byte[] buf = new byte[mac.getMacSize()];
        int bufLength = mac.doFinal(buf, 0);
        assert (bufLength == buf.length);
        this.dos.write(buf, 0, bufLength / 2);
    }
}

