/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.Constants;
import de.schlichtherle.truezip.zip.ExtraField;
import de.schlichtherle.truezip.zip.LittleEndian;
import de.schlichtherle.truezip.zip.UShort;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.TreeMap;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class ExtraFields
implements Cloneable {
    private Map<Integer, ExtraField> extra = new TreeMap<Integer, ExtraField>();

    ExtraFields() {
    }

    public ExtraFields clone() {
        try {
            ExtraFields clone = (ExtraFields)super.clone();
            clone.extra = new TreeMap<Integer, ExtraField>(this.extra);
            return clone;
        }
        catch (CloneNotSupportedException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    int size() {
        return this.extra.size();
    }

    @CheckForNull
    ExtraField get(int headerId) {
        assert (UShort.check(headerId));
        ExtraField ef = this.extra.get(headerId);
        assert (null == ef || ef.getHeaderId() == headerId);
        return ef;
    }

    ExtraField add(ExtraField ef) {
        int headerId = ef.getHeaderId();
        assert (UShort.check(headerId));
        return this.extra.put(headerId, ef);
    }

    @Nullable
    ExtraField remove(int headerId) {
        assert (UShort.check(headerId));
        ExtraField ef = this.extra.remove(headerId);
        assert (null == ef || ef.getHeaderId() == headerId);
        return ef;
    }

    int getExtraLength() {
        Map<Integer, ExtraField> extra = this.extra;
        if (extra.isEmpty()) {
            return 0;
        }
        int l = 0;
        for (ExtraField ef : extra.values()) {
            l += 4 + ef.getDataSize();
        }
        return l;
    }

    byte[] getExtra() {
        int size = this.getExtraLength();
        assert (UShort.check(size));
        if (0 == size) {
            return Constants.EMPTY;
        }
        byte[] data = new byte[size];
        this.writeTo(data, 0);
        return data;
    }

    void readFrom(byte[] data, int off, int size) {
        assert (UShort.check(size));
        TreeMap<Integer, ExtraField> map = new TreeMap<Integer, ExtraField>();
        if (null != data && 0 < size) {
            int end = off + size;
            while (off < end) {
                int headerId = LittleEndian.readUShort(data, off);
                int dataSize = LittleEndian.readUShort(data, off += 2);
                ExtraField ef = ExtraField.create(headerId);
                ef.readFrom(data, off += 2, dataSize);
                off += dataSize;
                map.put(headerId, ef);
            }
            assert (off == end);
        }
        this.extra = map;
    }

    void writeTo(byte[] data, int off) {
        for (ExtraField ef : this.extra.values()) {
            LittleEndian.writeShort(ef.getHeaderId(), data, off);
            LittleEndian.writeShort(ef.getDataSize(), data, off += 2);
            ef.writeTo(data, off += 2);
            off += ef.getDataSize();
        }
    }
}

