/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.archive.zip.ZipArchiveEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import de.schlichtherle.truezip.fs.archive.zip.ZipInputShop;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.OutputBusyException;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.JointIterator;
import de.schlichtherle.truezip.zip.RawZipOutputStream;
import de.schlichtherle.truezip.zip.ZipCryptoParameters;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public class ZipOutputShop
extends RawZipOutputStream<ZipArchiveEntry>
implements OutputShop<ZipArchiveEntry> {
    private final ZipDriver driver;
    private final FsModel model;
    @CheckForNull
    private IOPool.Entry<?> postamble;
    @CheckForNull
    private ZipArchiveEntry tempEntry;
    private ZipCryptoParameters param;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipOutputShop(ZipDriver driver, FsModel model, OutputStream out, @CheckForNull ZipInputShop source) throws IOException {
        super(out, null != source && source.isAppendee() ? source : null, driver);
        if (null == model) {
            throw new NullPointerException();
        }
        this.driver = driver;
        this.model = model;
        if (null != source) {
            if (!source.isAppendee()) {
                super.setComment(source.getComment());
                if (0L < source.getPreambleLength()) {
                    InputStream in = source.getPreambleInputStream();
                    try {
                        Streams.cat((InputStream)in, (OutputStream)(source.offsetsConsiderPreamble() ? this : out));
                    }
                    finally {
                        in.close();
                    }
                }
            }
            if (0L < source.getPostambleLength()) {
                this.postamble = (IOPool.Entry)this.getPool().allocate();
                Streams.copy((InputStream)source.getPostambleInputStream(), (OutputStream)this.postamble.getOutputSocket().newOutputStream());
            }
        }
    }

    public FsModel getModel() {
        return this.model;
    }

    private IOPool<?> getPool() {
        return this.driver.getPool();
    }

    @Override
    protected ZipCryptoParameters getCryptoParameters() {
        ZipCryptoParameters param = this.param;
        if (null == param) {
            this.param = param = this.driver.zipCryptoParameters(this);
        }
        return param;
    }

    public int getSize() {
        return super.size() + (null != this.tempEntry ? 1 : 0);
    }

    @Override
    public Iterator<ZipArchiveEntry> iterator() {
        ZipArchiveEntry tempEntry = this.tempEntry;
        if (null == tempEntry) {
            return super.iterator();
        }
        return new JointIterator(super.iterator(), Collections.singletonList(tempEntry).iterator());
    }

    @Override
    @CheckForNull
    public ZipArchiveEntry getEntry(String name) {
        ZipArchiveEntry entry = (ZipArchiveEntry)super.getEntry(name);
        if (null != entry) {
            return entry;
        }
        entry = this.tempEntry;
        return null != entry && name.equals(entry.getName()) ? entry : null;
    }

    public OutputSocket<ZipArchiveEntry> getOutputSocket(final ZipArchiveEntry lt) {
        if (null == lt) {
            throw new NullPointerException();
        }
        class Output
        extends OutputSocket<ZipArchiveEntry> {
            Output() {
            }

            public ZipArchiveEntry getLocalTarget() {
                return lt;
            }

            public OutputStream newOutputStream() throws IOException {
                long size;
                if (ZipOutputShop.this.isBusy()) {
                    throw new OutputBusyException(lt.getName());
                }
                boolean process = true;
                if (lt.isDirectory()) {
                    lt.setMethod(0);
                    lt.setCrc(0L);
                    lt.setCompressedSize(0L);
                    lt.setSize(0L);
                    return new EntryOutputStream(lt, true);
                }
                Entry pt = this.getPeerTarget();
                if (null != pt && -1L != (size = pt.getSize(Entry.Size.DATA))) {
                    lt.setSize(size);
                    if (pt instanceof ZipArchiveEntry) {
                        ZipArchiveEntry zpt = (ZipArchiveEntry)pt;
                        process = ZipOutputShop.this.driver.process(ZipOutputShop.this, lt, zpt);
                        if (!process) {
                            lt.setPlatform(zpt.getPlatform());
                            lt.setEncrypted(zpt.isEncrypted());
                            lt.setMethod(zpt.getMethod());
                            lt.setCompressedSize(zpt.getCompressedSize());
                            lt.setCrc(zpt.getCrc());
                            lt.setExtra(zpt.getExtra());
                        }
                    }
                }
                if (0 == lt.getMethod() && (-1L == lt.getCrc() || -1L == lt.getCompressedSize() || -1L == lt.getSize())) {
                    assert (process) : "The CRC-32, compressed size and size properties should be set in the peer target!";
                    return new BufferedEntryOutputStream((IOPool.Entry)ZipOutputShop.this.getPool().allocate(), lt, process);
                }
                return new EntryOutputStream(lt, process);
            }
        }
        return new Output();
    }

    @Override
    public final boolean isBusy() {
        return super.isBusy() || null != this.tempEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block10: {
            try {
                IOPool.Entry<?> postamble = this.postamble;
                if (null == postamble) break block10;
                this.postamble = null;
                try {
                    InputSocket input = postamble.getInputSocket();
                    InputStream in = input.newInputStream();
                    try {
                        long ol = this.length();
                        long ipl = ((Entry)input.getLocalTarget()).getSize(Entry.Size.DATA);
                        if ((ol + ipl) % 4L != 0L) {
                            this.write(new byte[4 - (int)(ol % 4L)]);
                        }
                        Streams.cat((InputStream)in, (OutputStream)((Object)this));
                    }
                    finally {
                        in.close();
                    }
                }
                finally {
                    postamble.release();
                }
            }
            finally {
                super.close();
            }
        }
    }

    private final class BufferedEntryOutputStream
    extends CheckedOutputStream {
        final IOPool.Entry<?> temp;
        final boolean process;
        boolean closed;

        BufferedEntryOutputStream(IOPool.Entry<?> temp, ZipArchiveEntry entry, boolean process) throws IOException {
            super(temp.getOutputSocket().newOutputStream(), new CRC32());
            assert (0 == entry.getMethod());
            this.temp = temp;
            ZipOutputShop.this.tempEntry = entry;
            this.process = process;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                try {
                    super.close();
                }
                finally {
                    long length = this.temp.getSize(Entry.Size.DATA);
                    ZipArchiveEntry tempEntry = ZipOutputShop.this.tempEntry;
                    assert (null != tempEntry);
                    assert (0 == tempEntry.getMethod());
                    tempEntry.setCrc(this.getChecksum().getValue());
                    tempEntry.setCompressedSize(length);
                    tempEntry.setSize(length);
                    this.store();
                }
            }
            finally {
                ZipOutputShop.this.tempEntry = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void store() throws IOException {
            try {
                InputStream in = this.temp.getInputSocket().newInputStream();
                try {
                    ZipArchiveEntry tempEntry = ZipOutputShop.this.tempEntry;
                    assert (null != tempEntry);
                    ZipOutputShop.this.putNextEntry(tempEntry, this.process);
                    try {
                        Streams.cat((InputStream)in, (OutputStream)((Object)ZipOutputShop.this));
                    }
                    finally {
                        ZipOutputShop.this.closeEntry();
                    }
                }
                finally {
                    in.close();
                }
            }
            finally {
                this.temp.release();
            }
        }
    }

    private final class EntryOutputStream
    extends DecoratingOutputStream {
        EntryOutputStream(ZipArchiveEntry entry, boolean process) throws IOException {
            super((OutputStream)((Object)ZipOutputShop.this));
            ZipOutputShop.this.putNextEntry(entry, process);
        }

        public void close() throws IOException {
            ZipOutputShop.this.closeEntry();
        }
    }
}

