/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.orchestrator;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plan;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plans;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.server.api.orchestrator.Orchestrator;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;

@Orchestrator.Metadata(name="group-based", description="Enforce a deployment order based on the deployment group property")
public class GroupBasedOrchestrator
implements Orchestrator {
    public Plan orchestrate(DeltaSpecification specification) {
        TreeMap treeMap = new TreeMap();
        treeMap.putAll(Multimaps.index((Iterable)specification.getDeltas(), (Function)new Function<Delta, Integer>(){

            public Integer apply(Delta input) {
                Container container = GroupBasedOrchestrator.this.getDeployed(input).getContainer();
                Integer deploymentGroup = Integer.MIN_VALUE;
                if (container.hasProperty("deploymentGroup")) {
                    deploymentGroup = (Integer)container.getProperty("deploymentGroup");
                }
                if (deploymentGroup == null) {
                    deploymentGroup = Integer.MIN_VALUE;
                }
                return deploymentGroup;
            }
        }).asMap());
        return Plans.serial((List)Lists.newArrayList((Iterable)Collections2.transform(treeMap.values(), (Function)new Function<Collection<Delta>, Plan>(){

            public Plan apply(Collection<Delta> input) {
                return Plans.interleaved((List)Lists.newArrayList(input));
            }
        })));
    }

    private Deployed<?, ?> getDeployed(Delta input) {
        return input.getDeployed() != null ? input.getDeployed() : input.getPrevious();
    }
}

