/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Resources;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.freemarker.FileUploader;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.util.OverthereUtils;
import freemarker.ext.dom.NodeModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class BaseStep<C extends ExecutionContext>
implements Step<C> {
    public static final String FREEMARKER_FILE_EXT = ".ftl";
    private String description;
    private HostContainer container;
    private String remoteWorkingDirPath;
    private boolean retainRemoteWorkingDirOnCompletion;
    private transient OverthereConnection localConn;
    private transient OverthereConnection remoteConn;
    private transient C ctx;
    private transient OverthereFile remoteWorkingDir;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected BaseStep(String description, HostContainer container) {
        this.description = description;
        this.container = container;
    }

    protected BaseStep(HostContainer container) {
        this(null, container);
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result handleExecute(C ctx) throws Exception {
        try {
            this.ctx = ctx;
            Step.Result result = this.doExecute();
            return result;
        }
        finally {
            this.disconnect();
        }
    }

    protected abstract Step.Result doExecute() throws Exception;

    protected C getCtx() {
        return this.ctx;
    }

    protected HostContainer getContainer() {
        return this.container;
    }

    public OverthereFile getRemoteWorkingDirectory() {
        if (this.remoteWorkingDir == null) {
            OverthereFile tempDir = Strings.isNullOrEmpty((String)this.getRemoteWorkingDirPath()) ? this.getRemoteConnection().getTempFile("generic_plugin", ".tmp") : this.getRemoteConnection().getFile(this.getRemoteWorkingDirPath());
            tempDir.mkdir();
            this.remoteWorkingDir = tempDir;
        }
        return this.remoteWorkingDir;
    }

    public OverthereConnection getLocalConnection() {
        if (this.localConn == null) {
            this.localConn = LocalConnection.getLocalConnection();
        }
        return this.localConn;
    }

    public OverthereConnection getRemoteConnection() {
        if (this.remoteConn == null) {
            this.remoteConn = this.container.getHost().getConnection();
        }
        return this.remoteConn;
    }

    protected void disconnect() {
        if (this.localConn != null) {
            Closeables.closeQuietly((Closeable)this.localConn);
        }
        if (!Strings.isNullOrEmpty((String)this.getRemoteWorkingDirPath()) && !this.isRetainRemoteWorkingDirOnCompletion()) {
            this.getRemoteWorkingDirectory().deleteRecursively();
        }
        if (this.remoteConn != null) {
            Closeables.closeQuietly((Closeable)this.remoteConn);
        }
        this.remoteWorkingDir = null;
        this.localConn = null;
        this.remoteConn = null;
    }

    public String getRemoteWorkingDirPath() {
        return this.remoteWorkingDirPath;
    }

    public void setRemoteWorkingDirPath(String remoteWorkingDirPath) {
        this.remoteWorkingDirPath = remoteWorkingDirPath;
    }

    public boolean isRetainRemoteWorkingDirOnCompletion() {
        return this.retainRemoteWorkingDirOnCompletion;
    }

    public void setRetainRemoteWorkingDirOnCompletion(boolean deleteWorkingDirOnCompletion) {
        this.retainRemoteWorkingDirOnCompletion = deleteWorkingDirOnCompletion;
    }

    protected OverthereFile uploadToWorkingDirectory(String content, String fileName) {
        this.getCtx().logOutput("Uploading file " + fileName + " to working directory.");
        OverthereFile target = this.getRemoteWorkingDirectory().getFile(fileName);
        OverthereUtils.write((byte[])content.getBytes(), (OverthereFile)target);
        return target;
    }

    protected OverthereFile uploadToWorkingDirectory(File content, String fileName) {
        String fileType = content.isDirectory() ? "directory" : "file";
        this.getCtx().logOutput("Uploading " + fileType + " " + fileName + " to working directory.");
        OverthereFile target = this.getRemoteWorkingDirectory().getFile(fileName);
        LocalFile.valueOf((File)content).copyTo(target);
        return target;
    }

    protected OverthereFile uploadToWorkingDirectory(URL content, String fileName) {
        this.getCtx().logOutput("Uploading file " + fileName + " to working directory.");
        OverthereFile target = this.getRemoteWorkingDirectory().getFile(fileName);
        OutputStream out = target.getOutputStream();
        try {
            Resources.copy((URL)content, (OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        finally {
            Closeables.closeQuietly((Closeable)out);
        }
        return target;
    }

    public boolean hostFileExists(String remoteFile) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)remoteFile));
        OverthereFile file = this.getRemoteConnection().getFile(remoteFile);
        return file.exists();
    }

    public String getHostLineSeparator() {
        return this.getContainer().getHost().getOs().getLineSeparator();
    }

    public String getHostFileSeparator() {
        return this.getContainer().getHost().getOs().getFileSeparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readHostFile(String remoteFile) {
        String string;
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)remoteFile));
        OverthereFile file = this.getRemoteConnection().getFile(remoteFile);
        Preconditions.checkArgument((boolean)file.exists(), (String)"File %s does not exist on host %s", (Object[])new Object[]{remoteFile, this.getContainer().getHost()});
        InputStream in = file.getInputStream();
        try {
            byte[] bytes = ByteStreams.toByteArray((InputStream)in);
            string = new String(bytes);
        }
        catch (Throwable throwable) {
            try {
                Closeables.closeQuietly((Closeable)in);
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIOException("Failed to read file " + remoteFile, (Throwable)e);
            }
        }
        Closeables.closeQuietly((Closeable)in);
        return string;
    }

    public String[] readHostFileLines(String remoteFile) {
        String data = this.readHostFile(remoteFile);
        Iterable iterable = Splitter.on((String)this.getHostLineSeparator()).split((CharSequence)data);
        return (String[])Iterables.toArray((Iterable)iterable, String.class);
    }

    public void createOrReplaceHostFile(String content, String remoteFile) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)remoteFile));
        Preconditions.checkNotNull((Object)content);
        OverthereFile file = this.getRemoteConnection().getFile(remoteFile);
        if (file.exists()) {
            this.logger.debug("File " + remoteFile + " already exists. Will delete before attempting to write.");
            file.delete();
        }
        ByteArrayInputStream from = new ByteArrayInputStream(content.getBytes());
        OutputStream to = file.getOutputStream();
        try {
            ByteStreams.copy((InputStream)from, (OutputStream)to);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Failed to write to " + remoteFile, (Throwable)e);
        }
        finally {
            Closeables.closeQuietly((Closeable)from);
            Closeables.closeQuietly((Closeable)to);
        }
    }

    public NodeModel readHostXmlFileAsModel(String remoteXmlFile) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)remoteXmlFile));
        OverthereFile file = this.getRemoteConnection().getFile(remoteXmlFile);
        Preconditions.checkArgument((boolean)file.exists(), (String)"File %s does not exist on host %s", (Object[])new Object[]{remoteXmlFile, this.getContainer().getHost()});
        InputStream remoteXmlStream = file.getInputStream();
        try {
            NodeModel nodeModel = NodeModel.parse((InputSource)new InputSource(remoteXmlStream), (boolean)false, (boolean)true);
            return nodeModel;
        }
        catch (ParserConfigurationException exc) {
            throw new RuntimeException("Cannot read xml file " + remoteXmlFile, exc);
        }
        catch (SAXException exc) {
            throw new RuntimeException("Cannot read xml file " + remoteXmlFile, exc);
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot read xml file " + remoteXmlFile, (Throwable)exc);
        }
        finally {
            Closeables.closeQuietly((Closeable)remoteXmlStream);
        }
    }

    public String evaluateTemplate(String templatePath, Map<String, Object> vars) {
        Configuration cfg = ConfigurationHolder.getConfiguration();
        try {
            Template template = cfg.getTemplate(templatePath);
            StringWriter sw = new StringWriter();
            template.createProcessingEnvironment(vars, (Writer)sw, (ObjectWrapper)new CiAwareObjectWrapper(new WorkingFolderUploader(this, this.getCtx()))).process();
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    protected void evaluateTemplate(OverthereFile renderTo, String templatePath, Map<String, Object> vars) {
        Configuration cfg = ConfigurationHolder.getConfiguration();
        OutputStream out = renderTo.getOutputStream();
        try {
            Template template = cfg.getTemplate(templatePath);
            template.process(vars, (Writer)new OutputStreamWriter(out));
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        finally {
            Closeables.closeQuietly((Closeable)out);
        }
    }

    public String resolveOsSpecificTemplate(String template) {
        if (this.classpathResourceExists(template + FREEMARKER_FILE_EXT)) {
            return template + FREEMARKER_FILE_EXT;
        }
        String osSpecificTemplate = template;
        String scriptExt = this.substringAfterLast(osSpecificTemplate, '.');
        if (scriptExt == null) {
            OperatingSystemFamily os = this.getContainer().getHost().getOs();
            osSpecificTemplate = osSpecificTemplate + os.getScriptExtension();
        }
        if (!this.classpathResourceExists(osSpecificTemplate)) {
            String osSpecificScriptTemplate = osSpecificTemplate + FREEMARKER_FILE_EXT;
            if (!this.classpathResourceExists(osSpecificScriptTemplate)) {
                throw new IllegalArgumentException("Resource " + osSpecificTemplate + " not found in classpath");
            }
            osSpecificTemplate = osSpecificScriptTemplate;
        }
        return osSpecificTemplate;
    }

    public boolean classpathResourceExists(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource) != null;
    }

    public String substringAfterLast(String str, char sub, String defaultValue) {
        String s = this.substringAfterLast(str, sub);
        if (s == null) {
            return defaultValue;
        }
        return s;
    }

    public String substringAfterLast(String str, char sub) {
        int pos = str.lastIndexOf(sub);
        if (pos == -1) {
            return null;
        }
        return str.substring(pos + 1);
    }

    private static class WorkingFolderUploader
    implements FileUploader {
        private Map<String, String> uploadedFiles = Maps.newHashMap();
        private C ctx;
        final /* synthetic */ BaseStep this$0;

        public WorkingFolderUploader(C ctx) {
            this.this$0 = var1_1;
            this.ctx = ctx;
        }

        @Override
        public String upload(OverthereFile file) {
            if (this.uploadedFiles.containsKey(file.getName())) {
                return this.uploadedFiles.get(file.getName());
            }
            OverthereFile uploadedFile = this.this$0.getRemoteWorkingDirectory().getFile(file.getName());
            if (!uploadedFile.exists()) {
                String fileType = file.isDirectory() ? "directory" : "file";
                this.ctx.logOutput("Uploading " + fileType + " " + file.getName() + " to working directory.");
                file.copyTo(uploadedFile);
            } else {
                this.this$0.logger.warn("Not uploading file " + file.getName() + " to working directory again because it has already been uploaded.");
            }
            this.uploadedFiles.put(file.getName(), uploadedFile.getPath());
            return uploadedFile.getPath();
        }
    }
}

