/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.overthere.step.CheckConnectionStep;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(root=Metadata.ConfigurationItemRoot.INFRASTRUCTURE, virtual=true, description="A machine that runs middleware, on which scripts can be executed, etc.")
public class Host
extends BaseContainer
implements HostContainer {
    @Property(description="Protocol to use when connecting to this host", hidden=true)
    private String protocol;
    @Property(description="Operating system")
    private OperatingSystemFamily os;
    @Property(description="Directory into which temporary files are stored. Will be cleaned up when the connection is closed.", required=false)
    private String temporaryDirectoryPath;
    private static Logger logger = LoggerFactory.getLogger(Host.class);

    public OverthereConnection getConnection() {
        logger.debug("Using connection protocol {}", (Object)this.protocol);
        return Overthere.getConnection((String)this.protocol, (ConnectionOptions)this.getConnectionOptions());
    }

    private ConnectionOptions getConnectionOptions() {
        ConnectionOptions options = new ConnectionOptions();
        this.copyPropertiesToConnectionOptions(options, (ConfigurationItem)this);
        if (!Strings.nullToEmpty((String)this.getTemporaryDirectoryPath()).trim().isEmpty()) {
            this.setConnectionOption(options, "tmp", this.getTemporaryDirectoryPath());
        }
        logger.debug("Created connection options: {}", (Object)options);
        return options;
    }

    protected void copyPropertiesToConnectionOptions(ConnectionOptions options, ConfigurationItem ci) {
        for (PropertyDescriptor pd : ci.getType().getDescriptor().getPropertyDescriptors()) {
            Object value = pd.get(ci);
            this.setConnectionOption(options, pd.getName(), value);
        }
    }

    private void setConnectionOption(ConnectionOptions options, String key, Object value) {
        if (key.equals("protocol") || key.equals("temporaryDirectoryPath")) {
            return;
        }
        if (value == null || Strings.isNullOrEmpty((String)value.toString())) {
            return;
        }
        if (key.equals("jumpstation")) {
            ConnectionOptions jumpstationOptions = new ConnectionOptions();
            this.copyPropertiesToConnectionOptions(jumpstationOptions, (ConfigurationItem)value);
            options.set(key, (Object)jumpstationOptions);
        } else {
            options.set(key, value);
        }
    }

    @ControlTask(description="Check connection")
    public List<Step<?>> checkConnection() {
        return Lists.newArrayList((Object[])new Step[]{new CheckConnectionStep(this)});
    }

    @Override
    public Host getHost() {
        return this;
    }

    public OperatingSystemFamily getOs() {
        return this.os;
    }

    public void setOs(OperatingSystemFamily os) {
        this.os = os;
    }

    public String getTemporaryDirectoryPath() {
        return this.temporaryDirectoryPath;
    }

    public void setTemporaryDirectoryPath(String temporaryDirectoryPath) {
        this.temporaryDirectoryPath = temporaryDirectoryPath;
    }
}

