/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.security.SecurityCallback;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityTemplate {
    public static <T> T executeAsAdmin(SecurityCallback<T> callback) {
        return SecurityTemplate.executeAs("admin", "admin", callback);
    }

    public static <T> T executeAs(Authentication credentials, SecurityCallback<T> callback) {
        return SecurityTemplate.executeAs(credentials.getName(), "", callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeAs(String username, String password, SecurityCallback<T> callback) {
        Authentication origAuthentication = SecurityTemplate.setCredentials(username, password);
        try {
            T t = callback.doAs();
            return t;
        }
        finally {
            SecurityTemplate.restoreAuthentication(origAuthentication);
        }
    }

    public static Authentication setCredentials(String username, String password) {
        return SecurityTemplate.setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
    }

    public static Authentication setAuthentication(Authentication authentication) {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication origAuthentication = context.getAuthentication();
        context.setAuthentication(authentication);
        return origAuthentication;
    }

    public static void restoreAuthentication(Authentication origAuthentication) {
        SecurityContextHolder.getContext().setAuthentication(origAuthentication);
    }
}

