/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.google.common.util.concurrent.Monitor;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.ssh.SshConnection;
import com.xebialabs.overthere.ssh.SshProcess;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.LocalPortForwarder;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshTunnelConnection
extends SshConnection
implements AddressPortMapper {
    private static final Monitor M = new Monitor();
    private static final int MAX_PORT = 65536;
    private Map<InetSocketAddress, InetSocketAddress> localPortForwards = Maps.newHashMap();
    private List<PortForwarder> portForwarders = Lists.newArrayList();
    private Integer startPortRange;
    private static final Logger logger = LoggerFactory.getLogger(SshTunnelConnection.class);

    public SshTunnelConnection(String string, ConnectionOptions connectionOptions, AddressPortMapper addressPortMapper) {
        super(string, connectionOptions, addressPortMapper);
        this.startPortRange = connectionOptions.get("portAllocationRangeStart", 1025);
    }

    @Override
    protected void connect() {
        super.connect();
        Preconditions.checkState((this.sshClient != null ? 1 : 0) != 0, (Object)"Should have set an SSH client when connected");
    }

    @Override
    public void doClose() {
        logger.debug("Closing tunnel.");
        for (PortForwarder portForwarder : this.portForwarders) {
            Closeables.closeQuietly((Closeable)portForwarder);
        }
        super.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetSocketAddress map(InetSocketAddress inetSocketAddress) {
        M.enter();
        try {
            if (this.localPortForwards.containsKey(inetSocketAddress)) {
                InetSocketAddress inetSocketAddress2 = this.localPortForwards.get(inetSocketAddress);
                return inetSocketAddress2;
            }
            ServerSocket serverSocket = this.bindAvailablePort();
            this.portForwarders.add(this.startForwarder(inetSocketAddress, serverSocket));
            InetSocketAddress inetSocketAddress3 = InetSocketAddress.createUnresolved("localhost", serverSocket.getLocalPort());
            this.localPortForwards.put(inetSocketAddress, inetSocketAddress3);
            InetSocketAddress inetSocketAddress4 = inetSocketAddress3;
            return inetSocketAddress4;
        }
        finally {
            M.leave();
        }
    }

    private ServerSocket bindAvailablePort() {
        for (int i = this.startPortRange.intValue(); i < 65536; ++i) {
            ServerSocket serverSocket = this.tryBind(i);
            if (serverSocket == null) continue;
            return serverSocket;
        }
        throw new IllegalStateException(String.format("Could not find a single free port in the range [%s-%s]...", this.startPortRange, 65536));
    }

    private ServerSocket tryBind(int n) {
        try {
            ServerSocket serverSocket = new ServerSocket();
            serverSocket.setReuseAddress(true);
            serverSocket.bind(new InetSocketAddress("localhost", n));
            return serverSocket;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private PortForwarder startForwarder(InetSocketAddress inetSocketAddress, ServerSocket serverSocket) {
        PortForwarder portForwarder = new PortForwarder(this.sshClient, inetSocketAddress, serverSocket);
        logger.info("Starting {}", (Object)portForwarder.getName());
        portForwarder.start();
        try {
            portForwarder.latch.await();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return portForwarder;
    }

    @Override
    protected OverthereFile getFile(String string, boolean bl) throws RuntimeIOException {
        throw new UnsupportedOperationException("Cannot get a file from the tunnel.");
    }

    @Override
    protected OverthereFile getFile(OverthereFile overthereFile, String string, boolean bl) throws RuntimeIOException {
        throw new UnsupportedOperationException("Cannot get a file from the tunnel.");
    }

    @Override
    public OverthereProcess startProcess(CmdLine cmdLine) {
        throw new UnsupportedOperationException("Cannot start a process on the tunnel.");
    }

    @Override
    protected CmdLine processCommandLine(CmdLine cmdLine) {
        throw new UnsupportedOperationException("Cannot process a command line for the tunnel.");
    }

    @Override
    protected SshProcess createProcess(Session session, CmdLine cmdLine) throws TransportException, ConnectionException {
        throw new UnsupportedOperationException("Cannot create a process in the tunnel.");
    }

    @Override
    public void setWorkingDirectory(OverthereFile overthereFile) {
        throw new UnsupportedOperationException("Cannot set a working directory on the tunnel.");
    }

    @Override
    public OverthereFile getWorkingDirectory() {
        throw new UnsupportedOperationException("Cannot get a working directory from the tunnel.");
    }

    @Override
    public int execute(OverthereProcessOutputHandler overthereProcessOutputHandler, CmdLine cmdLine) {
        throw new UnsupportedOperationException("Cannot execute a command on the tunnel.");
    }

    private static class PortForwarder
    extends Thread
    implements Closeable {
        private final SSHClient sshClient;
        private final InetSocketAddress remoteAddress;
        private final ServerSocket localSocket;
        private CountDownLatch latch = new CountDownLatch(1);

        public PortForwarder(SSHClient sSHClient, InetSocketAddress inetSocketAddress, ServerSocket serverSocket) {
            super(PortForwarder.buildName(inetSocketAddress, serverSocket.getLocalPort()));
            this.sshClient = sSHClient;
            this.remoteAddress = inetSocketAddress;
            this.localSocket = serverSocket;
        }

        private static String buildName(InetSocketAddress inetSocketAddress, Integer n) {
            return String.format("SSH local port forward thread [%d:%s]", n, inetSocketAddress.toString());
        }

        @Override
        public void run() {
            LocalPortForwarder.Parameters parameters = new LocalPortForwarder.Parameters("localhost", this.localSocket.getLocalPort(), this.remoteAddress.getHostName(), this.remoteAddress.getPort());
            LocalPortForwarder localPortForwarder = this.sshClient.newLocalPortForwarder(parameters, this.localSocket);
            try {
                this.latch.countDown();
                localPortForwarder.listen();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void close() throws IOException {
            this.localSocket.close();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

