/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.ssh.SshSftpConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshSftpWinSshdConnection
extends SshSftpConnection {
    private Logger logger = LoggerFactory.getLogger(SshSftpWinSshdConnection.class);

    public SshSftpWinSshdConnection(String string, ConnectionOptions connectionOptions, AddressPortMapper addressPortMapper) {
        super(string, connectionOptions, addressPortMapper);
        Preconditions.checkArgument((this.os == OperatingSystemFamily.WINDOWS ? 1 : 0) != 0, (String)"Cannot start a ssh:%s connection to a non-Windows operating system", (Object[])new Object[]{this.sshConnectionType.toString().toLowerCase()});
    }

    @Override
    protected String pathToSftpPath(String string) {
        if (string.length() < 2 || string.charAt(1) != ':') {
            throw new RuntimeIOException("Cannot translate path " + string + " because it is not a Windows path");
        }
        char c = Character.toUpperCase(string.charAt(0));
        String string2 = string.substring(2).replace('\\', '/');
        String string3 = "/" + c + string2;
        this.logger.trace("Translated path {} to sftp path {}", (Object)string, (Object)string3);
        return string3;
    }
}

