/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere;

import com.google.common.io.Closeables;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import com.xebialabs.overthere.spi.Protocol;
import com.xebialabs.overthere.ssh.SshTunnelConnection;
import com.xebialabs.overthere.util.DefaultAddressPortMapper;
import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import nl.javadude.scannit.Configuration;
import nl.javadude.scannit.Scannit;
import nl.javadude.scannit.scanner.AbstractScanner;
import nl.javadude.scannit.scanner.TypeAnnotationScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Overthere {
    private static final Logger logger = LoggerFactory.getLogger(Overthere.class);
    private static final AtomicReference<Map<String, Class<? extends OverthereConnectionBuilder>>> protocols = new AtomicReference(new HashMap());

    private Overthere() {
    }

    public static OverthereConnection getConnection(String string, ConnectionOptions connectionOptions) {
        if (!protocols.get().containsKey(string)) {
            throw new IllegalArgumentException("Unknown connection protocol " + string);
        }
        logger.trace("Connection for protocol {} requested with the following connection options: {}", (Object)string, (Object)connectionOptions);
        ConnectionOptions connectionOptions2 = connectionOptions.get("jumpstation", null);
        AddressPortMapper addressPortMapper = new DefaultAddressPortMapper();
        if (connectionOptions2 != null) {
            addressPortMapper = (SshTunnelConnection)Overthere.getConnection("ssh", connectionOptions2);
        }
        try {
            return Overthere.buildConnection(string, connectionOptions, addressPortMapper);
        }
        catch (RuntimeException runtimeException) {
            Closeables.closeQuietly((Closeable)addressPortMapper);
            throw runtimeException;
        }
    }

    private static OverthereConnection buildConnection(String string, ConnectionOptions connectionOptions, AddressPortMapper addressPortMapper) {
        Class<? extends OverthereConnectionBuilder> clazz = protocols.get().get(string);
        try {
            Constructor<? extends OverthereConnectionBuilder> constructor = clazz.getConstructor(String.class, ConnectionOptions.class, AddressPortMapper.class);
            OverthereConnectionBuilder overthereConnectionBuilder = constructor.newInstance(string, connectionOptions, addressPortMapper);
            logger.info("Connecting to {}", (Object)overthereConnectionBuilder);
            OverthereConnection overthereConnection = overthereConnectionBuilder.connect();
            logger.trace("Connected to {}", (Object)overthereConnection);
            return overthereConnection;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(clazz + " does not have a constructor that takes in a String and ConnectionOptions.", noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException("Cannot instantiate " + clazz, illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException("Cannot instantiate " + clazz, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Cannot instantiate " + clazz, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getCause();
            }
            throw new IllegalStateException("Cannot instantiate " + clazz, invocationTargetException);
        }
    }

    static {
        Scannit scannit = new Scannit(Configuration.config().scan("com.xebialabs").with(new AbstractScanner[]{new TypeAnnotationScanner()}));
        Set set = scannit.getTypesAnnotatedWith(Protocol.class);
        for (Class clazz : set) {
            if (OverthereConnectionBuilder.class.isAssignableFrom(clazz)) {
                String string = clazz.getAnnotation(Protocol.class).name();
                protocols.get().put(string, clazz);
                continue;
            }
            logger.warn("Skipping class {} because it is not a HostConnectionBuilder.", (Object)clazz);
        }
    }
}

