/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;

public class ConnectionOptions {
    public static final String OPERATING_SYSTEM = "os";
    public static final String TEMPORARY_DIRECTORY_PATH = "tmp";
    public static final String TEMPORARY_DIRECTORY_DELETE_ON_DISCONNECT = "tmpDeleteOnDisconnect";
    public static final boolean DEFAULT_TEMPORARY_DIRECTORY_DELETE_ON_DISCONNECT = true;
    public static final String TEMPORARY_FILE_CREATION_RETRIES = "tmpFileCreationRetries";
    public static final int DEFAULT_TEMPORARY_FILE_CREATION_RETRIES = 100;
    public static final String CONNECTION_TIMEOUT_MILLIS = "connectionTimeoutMillis";
    public static final int DEFAULT_CONNECTION_TIMEOUT_MILLIS = 120000;
    public static final String ADDRESS = "address";
    public static final String PORT = "port";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String JUMPSTATION = "jumpstation";
    private final Map<String, Object> options;
    private static final ImmutableSet<String> filteredKeys = ImmutableSet.of((Object)"password", (Object)"passphrase");

    public ConnectionOptions() {
        this.options = Maps.newHashMap();
    }

    public ConnectionOptions(ConnectionOptions connectionOptions) {
        this.options = Maps.newHashMap(connectionOptions.options);
    }

    public void set(String string, Object object) {
        this.options.put(string, object);
    }

    public <T> T get(String string) throws IllegalArgumentException {
        Object object = this.options.get(string);
        if (object == null) {
            throw new IllegalArgumentException("No value specified for required connection option " + string);
        }
        return (T)object;
    }

    public <T> T getOptional(String string) {
        return (T)this.options.get(string);
    }

    public <T> T get(String string, T t) {
        if (this.options.containsKey(string)) {
            return (T)this.options.get(string);
        }
        return t;
    }

    public boolean containsKey(String string) {
        return this.options.containsKey(string);
    }

    public Set<String> keys() {
        return this.options.keySet();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConnectionOptions connectionOptions = (ConnectionOptions)object;
        return ((Object)this.options).equals(connectionOptions.options);
    }

    public int hashCode() {
        return ((Object)this.options).hashCode();
    }

    public String toString() {
        return ConnectionOptions.print(this, "");
    }

    private static String print(ConnectionOptions connectionOptions, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ConnectionOptions[\n");
        for (Map.Entry<String, Object> entry : connectionOptions.options.entrySet()) {
            stringBuilder.append(string).append("\t").append(entry.getKey()).append(" --> ");
            Object object = entry.getValue();
            if (object instanceof ConnectionOptions) {
                stringBuilder.append(ConnectionOptions.print((ConnectionOptions)object, string + "\t"));
            } else {
                stringBuilder.append(filteredKeys.contains((Object)entry.getKey()) ? "********" : object);
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append(string).append("]");
        return stringBuilder.toString();
    }
}

