/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.NamespaceException;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NamespaceContext
implements NamespaceResolver {
    private final NamespaceContext parent;
    private final Map<String, String> prefixToURI;
    private final Map<String, String> uriToPrefix;

    public NamespaceContext(NamespaceContext parent, Map<String, String> mappings) {
        this.parent = parent;
        this.prefixToURI = new HashMap<String, String>();
        this.uriToPrefix = new HashMap<String, String>();
        for (Map.Entry<String, String> mapping : mappings.entrySet()) {
            this.prefixToURI.put(mapping.getKey(), mapping.getValue());
            this.uriToPrefix.put(mapping.getValue(), mapping.getKey());
        }
    }

    public NamespaceContext getParent() {
        return this.parent;
    }

    public String getURI(String prefix) throws NamespaceException {
        NamespaceContext current = this;
        while (current != null) {
            String uri = current.prefixToURI.get(prefix);
            if (uri != null) {
                return uri;
            }
            current = current.parent;
        }
        throw new NamespaceException("Unknown prefix: " + prefix);
    }

    public String getPrefix(String uri) throws NamespaceException {
        NamespaceContext current = this;
        while (current != null) {
            String prefix = current.uriToPrefix.get(uri);
            if (prefix != null) {
                return prefix;
            }
            current = current.parent;
        }
        throw new NamespaceException("Unknown URI: " + uri);
    }
}

