/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;

public final class PrivilegeRegistry {
    public static final String REP_WRITE = "{internal}write";
    private static final Set<InternalPrivilege> REGISTERED_PRIVILEGES = new HashSet<InternalPrivilege>(20);
    private static final Map<Integer, InternalPrivilege[]> BITS_TO_PRIVILEGES = new HashMap<Integer, InternalPrivilege[]>();
    private static final NameFactory NAME_FACTORY = NameFactoryImpl.getInstance();
    private static final Privilege[] EMPTY_ARRAY = new Privilege[0];
    public static final int NO_PRIVILEGE = 0;
    private static final int READ = 1;
    private static final int MODIFY_PROPERTIES = 2;
    private static final int ADD_CHILD_NODES = 4;
    private static final int REMOVE_CHILD_NODES = 8;
    private static final int REMOVE_NODE = 16;
    private static final int READ_AC = 32;
    private static final int MODIFY_AC = 64;
    private static final int NODE_TYPE_MNGMT = 128;
    private static final int VERSION_MNGMT = 256;
    private static final int LOCK_MNGMT = 512;
    private static final int LIFECYCLE_MNGMT = 1024;
    private static final int RETENTION_MNGMT = 2048;
    private static final int WRITE = 30;
    private static final int JACKRABBIT_WRITE = 158;
    private static final int ALL = 4095;
    private static final InternalPrivilege READ_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}read", 1));
    private static final InternalPrivilege MODIFY_PROPERTIES_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}modifyProperties", 2));
    private static final InternalPrivilege ADD_CHILD_NODES_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}addChildNodes", 4));
    private static final InternalPrivilege REMOVE_CHILD_NODES_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}removeChildNodes", 8));
    private static final InternalPrivilege REMOVE_NODE_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}removeNode", 16));
    private static final InternalPrivilege READ_AC_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}readAccessControl", 32));
    private static final InternalPrivilege MODIFY_AC_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}modifyAccessControl", 64));
    private static final InternalPrivilege NODE_TYPE_MANAGEMENT_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}nodeTypeManagement", 128));
    private static final InternalPrivilege VERSION_MANAGEMENT_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}versionManagement", 256));
    private static final InternalPrivilege LOCK_MANAGEMENT_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}lockManagement", 512));
    private static final InternalPrivilege LIFECYCLE_MANAGEMENT_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}lifecycleManagement", 1024));
    private static final InternalPrivilege RETENTION_MANAGEMENT_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}retentionManagement", 2048));
    private static final InternalPrivilege WRITE_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}write", new InternalPrivilege[]{MODIFY_PROPERTIES_PRIVILEGE, ADD_CHILD_NODES_PRIVILEGE, REMOVE_CHILD_NODES_PRIVILEGE, REMOVE_NODE_PRIVILEGE}));
    private static final InternalPrivilege JACKRABBIT_WRITE_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{internal}write", new InternalPrivilege[]{WRITE_PRIVILEGE, NODE_TYPE_MANAGEMENT_PRIVILEGE}));
    private static final InternalPrivilege ALL_PRIVILEGE = PrivilegeRegistry.registerPrivilege(new InternalPrivilege("{http://www.jcp.org/jcr/1.0}all", new InternalPrivilege[]{READ_PRIVILEGE, WRITE_PRIVILEGE, JACKRABBIT_WRITE_PRIVILEGE, READ_AC_PRIVILEGE, MODIFY_AC_PRIVILEGE, VERSION_MANAGEMENT_PRIVILEGE, LOCK_MANAGEMENT_PRIVILEGE, LIFECYCLE_MANAGEMENT_PRIVILEGE, RETENTION_MANAGEMENT_PRIVILEGE}));
    private final NameResolver resolver;
    private final Map<Name, Privilege> localCache;

    public PrivilegeRegistry(NameResolver resolver) {
        this.resolver = resolver;
        this.localCache = new HashMap<Name, Privilege>(REGISTERED_PRIVILEGES.size());
        for (InternalPrivilege ip : REGISTERED_PRIVILEGES) {
            PrivilegeImpl priv = new PrivilegeImpl(ip, resolver);
            this.localCache.put(ip.name, priv);
        }
    }

    public Privilege[] getRegisteredPrivileges() {
        return this.localCache.values().toArray(new Privilege[this.localCache.size()]);
    }

    public Privilege getPrivilege(String privilegeName) throws AccessControlException, RepositoryException {
        Name name = this.resolver.getQName(privilegeName);
        if (this.localCache.containsKey(name)) {
            return this.localCache.get(name);
        }
        throw new AccessControlException("Unknown privilege " + privilegeName);
    }

    public Privilege[] getPrivileges(int bits) {
        Privilege[] privs;
        if (bits > 0) {
            InternalPrivilege[] internalPrivs = PrivilegeRegistry.getInteralPrivileges(bits);
            privs = new Privilege[internalPrivs.length];
            for (int i = 0; i < internalPrivs.length; ++i) {
                privs[i] = this.localCache.get(internalPrivs[i].name);
            }
        } else {
            privs = new Privilege[]{};
        }
        return privs;
    }

    public static int getBits(Privilege[] privileges) throws AccessControlException {
        if (privileges == null || privileges.length == 0) {
            throw new AccessControlException("Privilege array is empty or null.");
        }
        int bits = 0;
        for (Privilege priv : privileges) {
            if (priv instanceof PrivilegeImpl) {
                bits |= ((PrivilegeImpl)priv).internalPrivilege.getBits();
                continue;
            }
            throw new AccessControlException("Unknown privilege '" + priv.getName() + "'.");
        }
        return bits;
    }

    public static int calculatePermissions(int privs, int parentPrivs, boolean isAllow, boolean protectsPolicy) {
        int perm = 0;
        if (protectsPolicy) {
            if ((parentPrivs & 0x20) == 32) {
                perm |= 1;
            }
            if ((parentPrivs & 0x40) == 64) {
                perm |= 4;
                perm |= 2;
                perm |= 8;
                perm |= 0x10;
                perm |= 0x80;
            }
        } else {
            if ((privs & 1) == 1) {
                perm |= 1;
            }
            if ((privs & 2) == 2) {
                perm |= 2;
                perm |= 0x10;
            }
            if ((parentPrivs & 4) == 4) {
                perm |= 4;
            }
            if ((parentPrivs & 4) == 4 && (parentPrivs & 8) == 8) {
                perm |= 0x1000;
            }
            if (isAllow) {
                if ((parentPrivs & 8) == 8 && (privs & 0x10) == 16) {
                    perm |= 8;
                }
            } else if ((parentPrivs & 8) == 8 || (privs & 0x10) == 16) {
                perm |= 8;
            }
        }
        if ((privs & 0x20) == 32) {
            perm |= 0x20;
        }
        if ((privs & 0x40) == 64) {
            perm |= 0x40;
        }
        if ((privs & 0x400) == 1024) {
            perm |= 0x400;
        }
        if ((privs & 0x200) == 512) {
            perm |= 0x200;
        }
        if ((privs & 0x80) == 128) {
            perm |= 0x80;
        }
        if ((privs & 0x800) == 2048) {
            perm |= 0x800;
        }
        if ((privs & 0x100) == 256) {
            perm |= 0x100;
        }
        return perm;
    }

    private static InternalPrivilege[] getInteralPrivileges(int bits) {
        InternalPrivilege[] privs;
        if (BITS_TO_PRIVILEGES.containsKey(bits)) {
            return BITS_TO_PRIVILEGES.get(bits);
        }
        ArrayList<InternalPrivilege> privileges = new ArrayList<InternalPrivilege>();
        if ((bits & 1) == 1) {
            privileges.add(READ_PRIVILEGE);
        }
        if ((bits & 0x9E) == 158) {
            privileges.add(JACKRABBIT_WRITE_PRIVILEGE);
        } else if ((bits & 0x1E) == 30) {
            privileges.add(WRITE_PRIVILEGE);
        } else {
            if ((bits & 2) == 2) {
                privileges.add(MODIFY_PROPERTIES_PRIVILEGE);
            }
            if ((bits & 4) == 4) {
                privileges.add(ADD_CHILD_NODES_PRIVILEGE);
            }
            if ((bits & 8) == 8) {
                privileges.add(REMOVE_CHILD_NODES_PRIVILEGE);
            }
            if ((bits & 0x10) == 16) {
                privileges.add(REMOVE_NODE_PRIVILEGE);
            }
            if ((bits & 0x80) == 128) {
                privileges.add(NODE_TYPE_MANAGEMENT_PRIVILEGE);
            }
        }
        if ((bits & 0x20) == 32) {
            privileges.add(READ_AC_PRIVILEGE);
        }
        if ((bits & 0x40) == 64) {
            privileges.add(MODIFY_AC_PRIVILEGE);
        }
        if ((bits & 0x100) == 256) {
            privileges.add(VERSION_MANAGEMENT_PRIVILEGE);
        }
        if ((bits & 0x200) == 512) {
            privileges.add(LOCK_MANAGEMENT_PRIVILEGE);
        }
        if ((bits & 0x400) == 1024) {
            privileges.add(LIFECYCLE_MANAGEMENT_PRIVILEGE);
        }
        if ((bits & 0x800) == 2048) {
            privileges.add(RETENTION_MANAGEMENT_PRIVILEGE);
        }
        if (!privileges.isEmpty()) {
            privs = privileges.toArray(new InternalPrivilege[privileges.size()]);
            BITS_TO_PRIVILEGES.put(bits, privs);
        } else {
            privs = new InternalPrivilege[]{};
        }
        return privs;
    }

    private static InternalPrivilege registerPrivilege(InternalPrivilege privilege) {
        REGISTERED_PRIVILEGES.add(privilege);
        BITS_TO_PRIVILEGES.put(privilege.getBits(), new InternalPrivilege[]{privilege});
        return privilege;
    }

    private class PrivilegeImpl
    implements Privilege {
        private final InternalPrivilege internalPrivilege;
        private final NameResolver resolver;

        private PrivilegeImpl(InternalPrivilege internalPrivilege, NameResolver resolver) {
            this.internalPrivilege = internalPrivilege;
            this.resolver = resolver;
        }

        public String getName() {
            try {
                return this.resolver.getJCRName(this.internalPrivilege.name);
            }
            catch (NamespaceException e) {
                return this.internalPrivilege.name.toString();
            }
        }

        public boolean isAbstract() {
            return this.internalPrivilege.isAbstract;
        }

        public boolean isAggregate() {
            return this.internalPrivilege.isAggregate;
        }

        public Privilege[] getDeclaredAggregatePrivileges() {
            if (this.internalPrivilege.isAggregate) {
                int len = this.internalPrivilege.declaredAggregates.length;
                Privilege[] privs = new Privilege[len];
                for (int i = 0; i < len; ++i) {
                    InternalPrivilege ip = this.internalPrivilege.declaredAggregates[i];
                    privs[i] = (Privilege)PrivilegeRegistry.this.localCache.get(ip.name);
                }
                return privs;
            }
            return EMPTY_ARRAY;
        }

        public Privilege[] getAggregatePrivileges() {
            if (this.internalPrivilege.isAggregate) {
                Privilege[] privs = new Privilege[this.internalPrivilege.aggregates.size()];
                int i = 0;
                for (InternalPrivilege ip : this.internalPrivilege.aggregates) {
                    privs[i++] = (Privilege)PrivilegeRegistry.this.localCache.get(ip.name);
                }
                return privs;
            }
            return EMPTY_ARRAY;
        }

        public int hashCode() {
            return this.internalPrivilege.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PrivilegeImpl) {
                PrivilegeImpl other = (PrivilegeImpl)obj;
                return this.internalPrivilege.equals(other.internalPrivilege);
            }
            return false;
        }
    }

    private static class InternalPrivilege {
        private final Name name;
        private final boolean isAbstract;
        private final boolean isAggregate;
        private final InternalPrivilege[] declaredAggregates;
        private final Set<InternalPrivilege> aggregates;
        private final int bits;

        private InternalPrivilege(String name, int bits) {
            if (name == null) {
                throw new IllegalArgumentException("A privilege must have a name.");
            }
            this.name = NAME_FACTORY.create(name);
            this.bits = bits;
            this.isAbstract = false;
            this.declaredAggregates = null;
            this.aggregates = null;
            this.isAggregate = false;
        }

        private InternalPrivilege(String name, InternalPrivilege[] declaredAggregates) {
            if (name == null) {
                throw new IllegalArgumentException("A privilege must have a name.");
            }
            this.name = NAME_FACTORY.create(name);
            this.isAbstract = false;
            this.declaredAggregates = declaredAggregates;
            HashSet<InternalPrivilege> aggrgt = new HashSet<InternalPrivilege>();
            int bts = 0;
            for (InternalPrivilege priv : declaredAggregates) {
                bts |= priv.getBits();
                if (priv.isAggregate) {
                    aggrgt.addAll(priv.aggregates);
                    continue;
                }
                aggrgt.add(priv);
            }
            this.aggregates = Collections.unmodifiableSet(aggrgt);
            this.bits = bts;
            this.isAggregate = true;
        }

        int getBits() {
            return this.bits;
        }

        public int hashCode() {
            return this.bits;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof InternalPrivilege) {
                return this.bits == ((InternalPrivilege)obj).bits;
            }
            return false;
        }
    }
}

