/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.version.OnParentVersionAction;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.commons.query.qom.Operator;
import org.apache.jackrabbit.core.nodetype.xml.AdditionalNamespaceResolver;
import org.apache.jackrabbit.core.util.DOMBuilder;
import org.apache.jackrabbit.core.value.InternalValueFactory;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueConstraint;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.nodetype.constraint.ValueConstraint;
import org.apache.jackrabbit.spi.commons.value.ValueFactoryQImpl;

public final class NodeTypeWriter {
    private final DOMBuilder builder = new DOMBuilder("nodeTypes");
    private final NamePathResolver resolver;
    private final ValueFactoryQImpl factory;

    public static void write(OutputStream xml, QNodeTypeDefinition[] types, NamespaceRegistry registry) throws IOException, RepositoryException {
        try {
            NodeTypeWriter writer = new NodeTypeWriter(registry);
            for (QNodeTypeDefinition type : types) {
                writer.addNodeTypeDef(type);
            }
            writer.write(xml);
        }
        catch (ParserConfigurationException e) {
            IOException e2 = new IOException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
        catch (NamespaceException e) {
            throw new RepositoryException("Invalid namespace reference in a node type definition", (Throwable)e);
        }
    }

    private NodeTypeWriter(NamespaceRegistry registry) throws ParserConfigurationException, RepositoryException {
        String[] prefixes;
        for (String prefix : prefixes = registry.getPrefixes()) {
            if ("".equals(prefix)) continue;
            String uri = registry.getURI(prefix);
            this.builder.setAttribute("xmlns:" + prefix, uri);
        }
        AdditionalNamespaceResolver nsResolver = new AdditionalNamespaceResolver(registry);
        this.resolver = new DefaultNamePathResolver((NamespaceResolver)nsResolver);
        this.factory = new ValueFactoryQImpl(InternalValueFactory.getInstance(), this.resolver);
    }

    private void addNodeTypeDef(QNodeTypeDefinition def) throws NamespaceException, RepositoryException {
        QNodeDefinition[] nodes;
        QPropertyDefinition[] properties;
        this.builder.startElement("nodeType");
        this.builder.setAttribute("name", this.resolver.getJCRName(def.getName()));
        this.builder.setAttribute("isMixin", def.isMixin());
        this.builder.setAttribute("isQueryable", def.isQueryable());
        this.builder.setAttribute("isAbstract", def.isAbstract());
        this.builder.setAttribute("hasOrderableChildNodes", def.hasOrderableChildNodes());
        Name item = def.getPrimaryItemName();
        if (item != null) {
            this.builder.setAttribute("primaryItemName", this.resolver.getJCRName(item));
        } else {
            this.builder.setAttribute("primaryItemName", "");
        }
        Name[] supertypes = def.getSupertypes();
        if (supertypes.length > 0) {
            this.builder.startElement("supertypes");
            for (Name supertype : supertypes) {
                this.builder.addContentElement("supertype", this.resolver.getJCRName(supertype));
            }
            this.builder.endElement();
        }
        for (QPropertyDefinition property : properties = def.getPropertyDefs()) {
            this.addPropDef(property);
        }
        for (QNodeDefinition node : nodes = def.getChildNodeDefs()) {
            this.addChildNodeDef(node);
        }
        this.builder.endElement();
    }

    private void addPropDef(QPropertyDefinition def) throws NamespaceException, RepositoryException {
        QValue[] defaults;
        List<String> defaultOps;
        List<String> ops;
        this.builder.startElement("propertyDefinition");
        this.builder.setAttribute("name", this.resolver.getJCRName(def.getName()));
        this.builder.setAttribute("autoCreated", def.isAutoCreated());
        this.builder.setAttribute("mandatory", def.isMandatory());
        this.builder.setAttribute("protected", def.isProtected());
        this.builder.setAttribute("onParentVersion", OnParentVersionAction.nameFromValue((int)def.getOnParentVersion()));
        this.builder.setAttribute("multiple", def.isMultiple());
        this.builder.setAttribute("isFullTextSearchable", def.isFullTextSearchable());
        this.builder.setAttribute("isQueryOrderable", def.isQueryOrderable());
        String[] qops = def.getAvailableQueryOperators();
        if (qops != null && qops.length > 0 && !(ops = Arrays.asList(qops)).containsAll(defaultOps = Arrays.asList(Operator.getAllQueryOperators()))) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < qops.length; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                if (qops[i].equals("jcr.operator.equal.to")) {
                    sb.append("OP_EQ");
                    continue;
                }
                if (qops[i].equals("jcr.operator.not.equal.to")) {
                    sb.append("OP_NE");
                    continue;
                }
                if (qops[i].equals("jcr.operator.greater.than")) {
                    sb.append("OP_GT");
                    continue;
                }
                if (qops[i].equals("jcr.operator.greater.than.or.equal.to")) {
                    sb.append("OP_GE");
                    continue;
                }
                if (qops[i].equals("jcr.operator.less.than")) {
                    sb.append("OP_LT");
                    continue;
                }
                if (qops[i].equals("jcr.operator.less.than.or.equal.to")) {
                    sb.append("OP_LE");
                    continue;
                }
                if (!qops[i].equals("jcr.operator.like")) continue;
                sb.append("OP_LIKE");
            }
            this.builder.setAttribute("availableQueryOperators", sb.toString());
        }
        this.builder.setAttribute("requiredType", PropertyType.nameFromValue((int)def.getRequiredType()));
        QValueConstraint[] constraints = def.getValueConstraints();
        if (constraints != null && constraints.length > 0) {
            this.builder.startElement("valueConstraints");
            for (QValueConstraint constraint : constraints) {
                ValueConstraint vc = ValueConstraint.create((int)def.getRequiredType(), (String)constraint.getString());
                this.builder.addContentElement("valueConstraint", vc.getDefinition(this.resolver));
            }
            this.builder.endElement();
        }
        if ((defaults = def.getDefaultValues()) != null && defaults.length > 0) {
            this.builder.startElement("defaultValues");
            for (QValue v : defaults) {
                this.builder.addContentElement("defaultValue", this.factory.createValue(v).getString());
            }
            this.builder.endElement();
        }
        this.builder.endElement();
    }

    private void addChildNodeDef(QNodeDefinition def) throws NamespaceException {
        this.builder.startElement("childNodeDefinition");
        this.builder.setAttribute("name", this.resolver.getJCRName(def.getName()));
        this.builder.setAttribute("autoCreated", def.isAutoCreated());
        this.builder.setAttribute("mandatory", def.isMandatory());
        this.builder.setAttribute("protected", def.isProtected());
        this.builder.setAttribute("onParentVersion", OnParentVersionAction.nameFromValue((int)def.getOnParentVersion()));
        this.builder.setAttribute("sameNameSiblings", def.allowsSameNameSiblings());
        Name type = def.getDefaultPrimaryType();
        if (type != null) {
            this.builder.setAttribute("defaultPrimaryType", this.resolver.getJCRName(type));
        } else {
            this.builder.setAttribute("defaultPrimaryType", "");
        }
        Name[] requiredTypes = def.getRequiredPrimaryTypes();
        this.builder.startElement("requiredPrimaryTypes");
        for (Name requiredType : requiredTypes) {
            this.builder.addContentElement("requiredPrimaryType", this.resolver.getJCRName(requiredType));
        }
        this.builder.endElement();
        this.builder.endElement();
    }

    private void write(OutputStream xml) throws IOException {
        this.builder.write(xml);
    }
}

