/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.ExifDescriptor;

public class ExifInteropDescriptor
extends TagDescriptor {
    public ExifInteropDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int n) throws MetadataException {
        switch (n) {
            case 1: {
                return this.getInteropIndexDescription();
            }
            case 2: {
                return this.getInteropVersionDescription();
            }
        }
        return this._directory.getString(n);
    }

    public String getInteropVersionDescription() throws MetadataException {
        if (!this._directory.containsTag(2)) {
            return null;
        }
        int[] nArray = this._directory.getIntArray(2);
        return ExifDescriptor.convertBytesToVersionString(nArray);
    }

    public String getInteropIndexDescription() {
        if (!this._directory.containsTag(1)) {
            return null;
        }
        String string = this._directory.getString(1).trim();
        if ("R98".equalsIgnoreCase(string)) {
            return "Recommended Exif Interoperability Rules (ExifR98)";
        }
        return "Unknown (" + string + ")";
    }
}

