/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.OutputSupplier;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.dto.ArtifactAndData;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDto;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDtos;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.io.DerivedArtifactFile;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.util.Either;
import com.xebialabs.deployit.util.PasswordObfuscator;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationItemDtoReader {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationItemDtoReader.class);

    public <T extends ConfigurationItem> T read(ConfigurationItemDto dto) {
        return this.read(dto, null);
    }

    public <T extends ConfigurationItem> T read(ConfigurationItemDto dto, WorkDir workDir) {
        return this.read(dto, workDir, Maps.newHashMap());
    }

    private <T extends ConfigurationItem> T read(ConfigurationItemDto dto, WorkDir workDir, Map<String, Either<ConfigurationItemDto, ConfigurationItem>> context) {
        Checks.checkNotNull((Object)dto, (String)"dto");
        Checks.checkNotNull((Object)dto.getId(), (String)"dto.id");
        Type type = Type.valueOf((String)dto.getType());
        Checks.checkArgument((boolean)type.exists(), (String)"Type %s does not exist", (Object[])new Object[]{type});
        Descriptor descriptor = type.getDescriptor();
        ConfigurationItem item = descriptor.newInstance();
        item.setId(dto.getId());
        context.put(item.getId(), (Either<ConfigurationItemDto, ConfigurationItem>)Either.right((Object)item));
        this.copyValues((RepositoryObject)dto, item, descriptor, workDir, context);
        if (item instanceof DerivedArtifact && workDir != null) {
            logger.trace("Setting DerivedFile on {}", (Object)dto.getId());
            ((DerivedArtifact)item).setFile((OverthereFile)DerivedArtifactFile.create((DerivedArtifact)((DerivedArtifact)item)));
        }
        return (T)item;
    }

    public ConfigurationItem read(ArtifactAndData dto, WorkDir workDir) {
        Checks.checkNotNull((Object)dto, (String)"dto");
        Artifact read = (Artifact)this.read((ConfigurationItemDto)dto.getArtifact(), workDir);
        read.setFile((OverthereFile)this.readArtifactData(dto, workDir));
        return read;
    }

    private LocalFile readArtifactData(ArtifactAndData dto, WorkDir workDir) {
        Checks.checkArgument((dto.getArtifact().getFilename() != null ? 1 : 0) != 0, (String)"The filename for the artifact should not be null", (Object[])new Object[0]);
        final LocalFile localFile = workDir.newFile(dto.getArtifact().getFilename());
        try {
            ByteStreams.write((byte[])dto.getData(), (OutputSupplier)new OutputSupplier<OutputStream>(){

                public OutputStream getOutput() throws IOException {
                    return localFile.getOutputStream();
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write Artifact data for " + dto.getArtifact().getId() + " to " + localFile);
        }
        return localFile;
    }

    private void copyValues(RepositoryObject src, ConfigurationItem dest, Descriptor descriptor, WorkDir workDir, Map<String, Either<ConfigurationItemDto, ConfigurationItem>> context) {
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            Object o = src.getValues().get(propertyDescriptor.getName());
            if (o == null) continue;
            propertyDescriptor.set(dest, this.convertValueIfNecessary(o, propertyDescriptor, workDir, context));
        }
    }

    private Object convertValueIfNecessary(Object dtoValue, PropertyDescriptor propertyDescriptor, WorkDir workDir, Map<String, Either<ConfigurationItemDto, ConfigurationItem>> context) {
        Object value = null;
        switch (propertyDescriptor.getKind()) {
            case STRING: {
                if (propertyDescriptor.isPassword()) {
                    value = PasswordObfuscator.ensureDecrypted((String)((String)((Object)dtoValue)));
                    break;
                }
            }
            case BOOLEAN: 
            case INTEGER: 
            case ENUM: {
                value = dtoValue;
                break;
            }
            case SET_OF_STRING: {
                value = this.handleSetOfString(dtoValue);
                break;
            }
            case SET_OF_CI: {
                value = Sets.newHashSet(this.handleCollectionOfConfigurationItem(dtoValue, workDir, context));
                break;
            }
            case LIST_OF_STRING: {
                value = this.handleListOfString(dtoValue);
                break;
            }
            case LIST_OF_CI: {
                value = Lists.newArrayList(this.handleCollectionOfConfigurationItem(dtoValue, workDir, context));
                break;
            }
            case CI: {
                value = this.handleConfigurationItem((String)((Object)dtoValue), workDir, context);
                break;
            }
            case MAP_STRING_STRING: {
                value = dtoValue != null ? Maps.newHashMap((Map)((Map)((Object)dtoValue))) : null;
            }
        }
        return value;
    }

    private Collection<ConfigurationItem> handleCollectionOfConfigurationItem(Object dtoValue, WorkDir workDir, Map<String, Either<ConfigurationItemDto, ConfigurationItem>> context) {
        ArrayList list = Lists.newArrayList();
        for (String id : (Collection)dtoValue) {
            list.add(this.handleConfigurationItem(id, workDir, context));
        }
        return list;
    }

    private ConfigurationItem handleConfigurationItem(String id, WorkDir workDir, Map<String, Either<ConfigurationItemDto, ConfigurationItem>> context) {
        if (context.containsKey(id)) {
            Either<ConfigurationItemDto, ConfigurationItem> either = context.get(id);
            if (either.getLeft() != null) {
                return this.read((ConfigurationItemDto)either.getLeft(), workDir, context);
            }
            return (ConfigurationItem)either.getRight();
        }
        ConfigurationItem ci = RepositoryServiceHolder.getRepositoryService().read(id, workDir);
        context.put(ci.getId(), (Either<ConfigurationItemDto, ConfigurationItem>)Either.right((Object)ci));
        return ci;
    }

    private Set<String> handleSetOfString(Object dtoValue) {
        if (dtoValue instanceof Set) {
            return Sets.newHashSet((Iterable)((Set)dtoValue));
        }
        if (dtoValue instanceof Collection) {
            return Sets.newHashSet((Iterable)((Collection)dtoValue));
        }
        throw new IllegalStateException("Did not get a Set of String or other Collection type, but a: " + dtoValue);
    }

    private List<String> handleListOfString(Object dtoValue) {
        if (dtoValue instanceof List) {
            return Lists.newArrayList((Iterable)((List)dtoValue));
        }
        if (dtoValue instanceof Collection) {
            return Lists.newArrayList((Iterable)((Collection)dtoValue));
        }
        throw new IllegalStateException("Did not get a List of String or other Collection type, but a: " + dtoValue);
    }

    public List<ConfigurationItem> read(ConfigurationItemDtos dtos) {
        return this.read(dtos.getObjects(), null);
    }

    public List<ConfigurationItem> read(List<ConfigurationItemDto> dtos) {
        return this.read(dtos, null);
    }

    public List<ConfigurationItem> read(List<ConfigurationItemDto> dtos, WorkDir workDir) {
        ArrayList cis = Lists.newArrayList();
        Map<String, Either<ConfigurationItemDto, ConfigurationItem>> context = this.buildContext(dtos);
        for (ConfigurationItemDto dto : dtos) {
            Object read = this.read(dto, workDir, context);
            cis.add(read);
        }
        return cis;
    }

    private Map<String, Either<ConfigurationItemDto, ConfigurationItem>> buildContext(List<ConfigurationItemDto> dtos) {
        HashMap context = Maps.newHashMap();
        for (ConfigurationItemDto dto : dtos) {
            context.put(dto.getId(), Either.left((Object)dto));
        }
        return context;
    }
}

