/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.StructurePseudo;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.DatatypeIterator;
import ucar.nc2.dt.StationImpl;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.point.RecordDatasetHelper;
import ucar.nc2.dt.point.StationObsDatasetImpl;
import ucar.nc2.dt.point.UnidataObsDatasetHelper;
import ucar.nc2.dt.point.UnidataStationObsDataset;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.Station;

public class CFstationObsDataset
extends StationObsDatasetImpl
implements TypedDatasetFactoryIF {
    private static Logger log = LoggerFactory.getLogger(UnidataStationObsDataset.class);
    private Variable latVar;
    private Variable lonVar;
    private Variable altVar;
    private Variable timeVar;
    private Variable lastVar;
    private Variable prevVar;
    private Variable firstVar;
    private Variable nextVar;
    private Variable numChildrenVar;
    private Variable stationIndexVar;
    private Variable stationIdVar;
    private Variable stationDescVar;
    private Variable numStationsVar;
    private boolean hasForwardLinkedList;
    private boolean hasBackwardLinkedList;
    private boolean hasContiguousList;
    private Structure recordVar;
    private RecordDatasetHelper recordHelper;
    private boolean debugRead = false;
    private int firstRecord = 0;

    public static boolean isValidFile(NetcdfFile ds) {
        if (!ds.findAttValueIgnoreCase(null, "cdm_datatype", "").equalsIgnoreCase(FeatureType.STATION.toString())) {
            return false;
        }
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (conv == null) {
            return false;
        }
        StringTokenizer stoke = new StringTokenizer(conv, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (!toke.equalsIgnoreCase("CF-1.0")) continue;
            return true;
        }
        return false;
    }

    public boolean isMine(NetcdfDataset ds) {
        return CFstationObsDataset.isValidFile(ds);
    }

    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new CFstationObsDataset(ncd);
    }

    public CFstationObsDataset() {
    }

    public CFstationObsDataset(NetcdfDataset ds) throws IOException {
        super(ds);
        this.latVar = UnidataObsDatasetHelper.getCoordinate(ds, AxisType.Lat);
        this.lonVar = UnidataObsDatasetHelper.getCoordinate(ds, AxisType.Lon);
        this.altVar = UnidataObsDatasetHelper.getCoordinate(ds, AxisType.Height);
        this.timeVar = UnidataObsDatasetHelper.getCoordinate(ds, AxisType.Time);
        if (this.latVar == null) {
            throw new IllegalStateException("Missing latitude variable");
        }
        if (this.lonVar == null) {
            throw new IllegalStateException("Missing longitude coordinate variable");
        }
        if (this.timeVar == null) {
            throw new IllegalStateException("Missing time coordinate variable");
        }
        this.lastVar = UnidataObsDatasetHelper.findVariable(ds, "lastChild");
        this.prevVar = UnidataObsDatasetHelper.findVariable(ds, "prevChild");
        this.firstVar = UnidataObsDatasetHelper.findVariable(ds, "firstChild");
        this.nextVar = UnidataObsDatasetHelper.findVariable(ds, "nextChild");
        this.numChildrenVar = UnidataObsDatasetHelper.findVariable(ds, "numChildren");
        this.stationIndexVar = UnidataObsDatasetHelper.findVariable(ds, "parent_index");
        if (this.stationIndexVar == null) {
            throw new IllegalStateException("Missing parent_index variable");
        }
        this.hasForwardLinkedList = this.firstVar != null && this.nextVar != null;
        this.hasBackwardLinkedList = this.lastVar != null && this.prevVar != null;
        this.hasContiguousList = this.firstVar != null && this.numChildrenVar != null;
        this.stationIdVar = UnidataObsDatasetHelper.findVariable(ds, "station_id");
        this.stationDescVar = UnidataObsDatasetHelper.findVariable(ds, "station_description");
        this.numStationsVar = UnidataObsDatasetHelper.findVariable(ds, "number_stations");
        if (this.stationIdVar == null) {
            throw new IllegalStateException("Missing station id variable");
        }
        this.recordHelper = new RecordDatasetHelper(ds, this.timeVar.getName(), null, this.dataVariables, this.parseInfo);
        this.recordHelper.setStationInfo(this.stationIndexVar.getName(), this.stationDescVar == null ? null : this.stationDescVar.getName());
        this.removeDataVariable(this.stationIndexVar.getName());
        this.removeDataVariable(this.timeVar.getName());
        if (this.prevVar != null) {
            this.removeDataVariable(this.prevVar.getName());
        }
        if (this.nextVar != null) {
            this.removeDataVariable(this.nextVar.getName());
        }
        this.recordVar = this.recordHelper.recordVar;
        this.timeUnit = this.recordHelper.timeUnit;
        this.title = ds.findAttValueIgnoreCase(null, "title", "");
        this.desc = ds.findAttValueIgnoreCase(null, "description", "");
        this.readStationTable();
    }

    private void readStationTable() throws IOException {
        Dimension stationDim = this.ncfile.findDimension("station");
        StructurePseudo stationTable = new StructurePseudo((NetcdfFile)this.ncfile, null, "stationTable", stationDim);
        ArrayStructure stationData = (ArrayStructure)stationTable.read();
        int nstations = 0;
        nstations = this.numStationsVar != null ? this.numStationsVar.readScalarInt() : stationDim.getLength();
        this.recordHelper.stnHash = new HashMap<Object, Station>(2 * nstations);
        for (int i = 0; i < nstations; ++i) {
            StructureData sdata = stationData.getStructureData(i);
            CFStationImpl bean = new CFStationImpl(sdata.getScalarString(this.stationIdVar.getName()), sdata.getScalarString(this.stationDescVar.getName()), sdata.convertScalarDouble(this.latVar.getName()), sdata.convertScalarDouble(this.lonVar.getName()), sdata.convertScalarDouble(this.altVar.getName()));
            this.stations.add(bean);
            this.recordHelper.stnHash.put(i, bean);
        }
    }

    private void readStationIndex() throws IOException {
        Array stationIndexArray = this.stationIndexVar.read();
        Dimension stationDim = this.ncfile.findDimension("station");
        StructurePseudo stationTable = new StructurePseudo((NetcdfFile)this.ncfile, null, "stationTable", stationDim);
        ArrayStructure stationData = (ArrayStructure)stationTable.read();
        int nstations = 0;
        nstations = this.numStationsVar != null ? this.numStationsVar.readScalarInt() : stationDim.getLength();
        this.recordHelper.stnHash = new HashMap<Object, Station>(2 * nstations);
        for (int i = 0; i < nstations; ++i) {
            StructureData sdata = stationData.getStructureData(i);
            CFStationImpl bean = new CFStationImpl(sdata.getScalarString(this.stationIdVar.getName()), sdata.getScalarString(this.stationDescVar.getName()), sdata.convertScalarDouble(this.latVar.getName()), sdata.convertScalarDouble(this.lonVar.getName()), sdata.convertScalarDouble(this.altVar.getName()));
            this.stations.add(bean);
            this.recordHelper.stnHash.put(i, bean);
        }
    }

    protected void setTimeUnits() {
    }

    protected void setStartDate() {
    }

    protected void setEndDate() {
    }

    protected void setBoundingBox() {
        this.boundingBox = this.stationHelper.getBoundingBox();
    }

    public List getData(CancelTask cancel) throws IOException {
        ArrayList allData = new ArrayList();
        int n = this.getDataCount();
        return allData;
    }

    public int getDataCount() {
        Dimension unlimitedDim = this.ncfile.getUnlimitedDimension();
        return unlimitedDim.getLength();
    }

    public List getData(Station s, CancelTask cancel) throws IOException {
        return ((CFStationImpl)s).getObservations();
    }

    protected RecordDatasetHelper.RecordStationObs makeObs(int recno, boolean storeData, StructureData sdata) throws IOException {
        try {
            double obsTime;
            int stationIndex;
            if (recno > this.getDataCount()) {
                int n = this.getDataCount();
                this.ncfile.syncExtend();
                log.info("UnidataStationObsDataset.makeObs recno=" + recno + " > " + n + "; after sync= " + this.getDataCount());
            }
            if (null == sdata) {
                sdata = this.recordVar.readStructure(recno);
            }
            if ((stationIndex = sdata.getScalarInt(this.stationIndexVar.getShortName())) < 0 || stationIndex >= this.stations.size()) {
                this.parseInfo.append("cant find station at index = " + stationIndex + "\n");
                return null;
            }
            Station station = (Station)this.stations.get(stationIndex);
            if (station == null) {
                this.parseInfo.append("cant find station at index = " + stationIndex + "\n");
                return null;
            }
            double nomTime = obsTime = this.getTime(this.timeVar, sdata);
            if (storeData) {
                RecordDatasetHelper recordDatasetHelper = this.recordHelper;
                recordDatasetHelper.getClass();
                return new RecordDatasetHelper.RecordStationObs(recordDatasetHelper, station, obsTime, nomTime, sdata);
            }
            RecordDatasetHelper recordDatasetHelper = this.recordHelper;
            recordDatasetHelper.getClass();
            return new RecordDatasetHelper.RecordStationObs(recordDatasetHelper, station, obsTime, nomTime, recno);
        }
        catch (InvalidRangeException e) {
            log.error("CFStationObsDataset.makeObs recno=" + recno, (Throwable)e);
            throw new IOException(e.getMessage());
        }
        catch (ParseException e) {
            log.error("CFStationObsDataset.makeObs recno=" + recno, (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    public DataIterator getDataIterator(Station s) {
        return ((CFStationImpl)s).iterator();
    }

    public DataIterator getDataIterator(Station s, Date start, Date end) {
        return ((CFStationImpl)s).iterator(start, end);
    }

    public DataIterator getDataIterator(int bufferSize) throws IOException {
        return new StationDatatypeIterator(this.recordHelper.recordVar, bufferSize);
    }

    private class StationDatatypeIterator
    extends DatatypeIterator {
        protected Object makeDatatypeWithData(int recnum, StructureData sdata) throws IOException {
            return CFstationObsDataset.this.makeObs(recnum, true, sdata);
        }

        StationDatatypeIterator(Structure struct, int bufferSize) {
            super(struct, bufferSize);
        }
    }

    private class CFStationImpl
    extends StationImpl {
        private CFStationImpl(String name, String desc, double lat, double lon, double elev) {
            super(name, desc, lat, lon, elev, -1);
        }

        protected ArrayList readObservations() throws IOException {
            ArrayList obs = new ArrayList();
            int recno = CFstationObsDataset.this.firstRecord;
            int end = CFstationObsDataset.this.firstRecord + this.count - 1;
            int nextRecord = CFstationObsDataset.this.firstRecord;
            while (recno >= 0) {
                try {
                    if (recno > CFstationObsDataset.this.getDataCount()) {
                        int n = CFstationObsDataset.this.getDataCount();
                        CFstationObsDataset.this.ncfile.syncExtend();
                        log.info("UnidataStationObsDataset.makeObs recno=" + recno + " > " + n + "; after sync= " + CFstationObsDataset.this.getDataCount());
                    }
                    StructureData sdata = CFstationObsDataset.this.recordVar.readStructure(recno);
                    recno = nextRecord;
                }
                catch (InvalidRangeException e) {
                    log.error("UnidataStationObsDataset.readObservation recno=" + recno, (Throwable)e);
                    throw new IOException(e.getMessage());
                }
            }
            Collections.sort(obs);
            return obs;
        }

        DataIterator iterator() {
            return new StationIterator();
        }

        DataIterator iterator(Date start, Date end) {
            return new StationIterator(start, end);
        }

        private class StationIterator
        implements DataIterator {
            int nextRecno;
            int last;
            double startTime;
            double endTime;
            boolean hasDateRange;

            StationIterator() {
                this.nextRecno = CFstationObsDataset.this.firstRecord;
                this.last = CFstationObsDataset.this.firstRecord + CFStationImpl.this.count - 1;
            }

            StationIterator(Date start, Date end) {
                this.nextRecno = CFstationObsDataset.this.firstRecord;
                this.last = CFstationObsDataset.this.firstRecord + CFStationImpl.this.count - 1;
                this.startTime = CFstationObsDataset.this.timeUnit.makeValue(start);
                this.endTime = CFstationObsDataset.this.timeUnit.makeValue(end);
                this.hasDateRange = true;
            }

            public boolean hasNext() {
                return this.nextRecno >= 0;
            }

            public Object nextData() throws IOException {
                double timeValue;
                RecordDatasetHelper.RecordStationObs sobs = CFstationObsDataset.this.makeObs(this.nextRecno, true, null);
                if (!sobs.getStation().getName().equals(CFStationImpl.this.getName())) {
                    throw new IllegalStateException("BAD Station link (" + this.nextRecno + ") station name=" + sobs.getStation().getName() + " should be " + CFStationImpl.this.getName());
                }
                if (this.hasDateRange && ((timeValue = sobs.getObservationTime()) < this.startTime || timeValue > this.endTime)) {
                    return this.nextData();
                }
                return sobs;
            }

            public Object next() {
                try {
                    return this.nextData();
                }
                catch (IOException e) {
                    log.error("CFStationObsDataset.StationIterator.next recno=" + this.nextRecno, (Throwable)e);
                    throw new IllegalStateException(e.getMessage());
                }
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

