/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.CliOptions;
import com.xebialabs.deployit.cli.Interpreter;
import com.xebialabs.deployit.cli.ScriptEngineBuilder;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.help.HelpScanner;
import com.xebialabs.deployit.cli.ssl.SelfSignedCertificateAcceptingSocketFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.script.ScriptException;
import jline.Terminal;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import nl.javadude.scannit.Configuration;
import nl.javadude.scannit.Scannit;
import nl.javadude.scannit.scanner.AbstractScanner;
import nl.javadude.scannit.scanner.TypeAnnotationScanner;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cli {
    private static final AtomicReference<Properties> properties = new AtomicReference();
    private static ConsoleReader consoleReader;
    private static final FilenameFilter CLI_EXTENSION_FILTER;
    private ScriptEngineBuilder scriptEngine;
    private CliOptions options;
    private static Authentication authentication;

    public Cli(CliOptions options) throws Exception {
        this.options = options;
        this.scriptEngine = this.createEngine();
        this.initialize();
    }

    private void printBanner() {
        this.bannerPrint("Welcome to the Deployit Jython CLI!");
        this.bannerPrint("Type 'help' to learn about the objects you can use to interact with Deployit.");
        this.bannerPrint("");
    }

    private void initialize() throws Exception {
        Cli.setAuthentication(this.createCredentials());
        this.setupSecureCommunications();
        authentication.init(this.options);
        this.attemptToConnectToServer(authentication);
        this.printBanner();
        Proxies proxies = this.createAndRegisterProxies(authentication);
        this.registerCliObjects(proxies);
    }

    private void setupSecureCommunications() {
        if (this.options.isSecured()) {
            Protocol easyhttps = new Protocol("https", (ProtocolSocketFactory)new SelfSignedCertificateAcceptingSocketFactory(), 443);
            Protocol.registerProtocol((String)"https", (Protocol)easyhttps);
        }
    }

    private Proxies createAndRegisterProxies(Authentication client) {
        Proxies proxies = new Proxies(this.options, client);
        if (this.options.isExposeProxies()) {
            System.out.println("Exposing Proxies!");
            this.scriptEngine.put("proxies", proxies);
        }
        return proxies;
    }

    public static void main(String[] args) throws Exception {
        CliOptions options = CliOptions.parse(args);
        if (options == null) {
            return;
        }
        consoleReader = Cli.setupConsole();
        new Cli(options).getNewInterpreter().interpret();
    }

    private static ConsoleReader setupConsole() throws IOException {
        final Terminal terminal = TerminalFactory.create();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    terminal.restore();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        ConsoleReader cr = new ConsoleReader();
        cr.setExpandEvents(false);
        return cr;
    }

    private ScriptEngineBuilder createEngine() {
        return new ScriptEngineBuilder();
    }

    public Interpreter getNewInterpreter() throws ScriptException, FileNotFoundException {
        Interpreter interpreter = new Interpreter(consoleReader, this.scriptEngine, this.options);
        this.readExtensions(interpreter);
        return interpreter;
    }

    private void registerCliObjects(Proxies proxies) throws Exception {
        Scannit scannit = new Scannit(Configuration.config().with(new AbstractScanner[]{new TypeAnnotationScanner()}).scan("com.xebialabs"));
        Set classes = scannit.getTypesAnnotatedWith(CliObject.class);
        for (Class cliObject : classes) {
            Constructor constructor = cliObject.getConstructor(Proxies.class);
            Object o = constructor.newInstance(proxies);
            String name = cliObject.getAnnotation(CliObject.class).name();
            this.scriptEngine.put(name, o);
        }
        if (!this.options.isQuiet()) {
            HelpScanner.printHelp(classes);
        }
    }

    public Authentication createCredentials() throws IOException {
        Authentication authentication = new Authentication();
        authentication.username = this.options.isUsernameOnCommandline() ? this.options.getUsername() : (this.deployitConfigurationFileExists() ? this.readFromProperties("cli.username") : consoleReader.readLine("username >"));
        authentication.password = this.options.isPasswordOnCommandline() ? this.options.getPassword() : (this.deployitConfigurationFileExists() ? this.readFromProperties("cli.password") : consoleReader.readLine("password >", Character.valueOf('\u0000')));
        return authentication;
    }

    private boolean deployitConfigurationFileExists() {
        return this.options.getConfigurationFile().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFromProperties(String key) throws IOException {
        if (properties.get() == null) {
            Properties props = new Properties();
            FileInputStream inStream = new FileInputStream(this.options.getConfigurationFile());
            try {
                props.load(inStream);
            }
            finally {
                Closeables.closeQuietly((Closeable)inStream);
            }
            properties.set(props);
        }
        return properties.get().getProperty(key);
    }

    private void attemptToConnectToServer(Authentication authentication) {
        String urlToConnectTo = this.options.getUrl();
        System.out.println("Connecting to the Deployit server at " + urlToConnectTo + "...");
        try {
            int responseCode = authentication.getHttpClient().executeMethod((HttpMethod)new GetMethod(urlToConnectTo + "/server/info"));
            if (responseCode != 200) {
                if (responseCode == 401 || responseCode == 403) {
                    throw new IllegalStateException("You were not authenticated correctly, did you use the correct credentials?");
                }
                throw new IllegalStateException("Could contact the server at " + urlToConnectTo + " but received an HTTP error code, " + responseCode);
            }
            System.out.println("Succesfully connected.");
        }
        catch (MalformedURLException mue) {
            throw new IllegalStateException("Could not contact the server at " + urlToConnectTo, mue);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not contact the server at " + urlToConnectTo, e);
        }
    }

    private void readExtensions(Interpreter interpreter) throws ScriptException, FileNotFoundException {
        File[] files;
        File extensionDir = new File("ext");
        if (!extensionDir.exists() || !extensionDir.isDirectory()) {
            System.out.println("No extension directory present.");
            return;
        }
        for (File extension : files = extensionDir.listFiles(CLI_EXTENSION_FILTER)) {
            this.bannerPrint("Reading extension: " + extension);
            interpreter.evaluate(new FileReader(extension));
        }
    }

    public static Authentication getAuthentication() {
        return authentication;
    }

    static void setAuthentication(Authentication authentication) {
        Cli.authentication = authentication;
    }

    void bannerPrint(String line) {
        if (!this.options.isQuiet()) {
            System.out.println(line);
        }
    }

    static {
        CLI_EXTENSION_FILTER = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".py") || name.endsWith(".cli");
            }
        };
    }

    public static class Authentication {
        String username;
        String password;
        HttpClient httpClient;
        private static final Logger logger = LoggerFactory.getLogger(Authentication.class);

        void init(CliOptions options) {
            this.httpClient = new HttpClient();
            this.addCredentials();
            this.httpClient.getParams().setAuthenticationPreemptive(true);
            this.httpClient.getParams().setConnectionManagerTimeout(10000L);
            HostConfiguration hostConfiguration = new HostConfiguration();
            hostConfiguration.setHost(options.getHost(), options.getPort(), String.format("http%s", options.isSecured() ? "s" : ""));
            this.httpClient.setHostConfiguration(hostConfiguration);
        }

        private void addCredentials() {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.username, this.password);
            this.httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        }

        public void logout() {
            this.username = null;
            this.password = null;
            this.httpClient.getState().clearCookies();
            this.httpClient.getState().clearCredentials();
        }

        public String getUserName() {
            return this.username;
        }

        public void loginAs(String username, String password) {
            if (this.httpClient.getState().getCredentials(AuthScope.ANY) != null) {
                logger.error("You're still logged in as another user, please logout first.");
                return;
            }
            this.username = username;
            this.password = password;
            this.addCredentials();
            this.httpClient.getState().clearCookies();
        }

        public HttpClient getHttpClient() {
            return this.httpClient;
        }
    }
}

