/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.util;

import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.OverthereFileDirectoryWalker;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OverthereFileCopier
extends OverthereFileDirectoryWalker {
    private static final String SOURCE = "Source";
    private static final String DESTINATION = "Destination";
    private Stack<OverthereFile> dstDirStack = new Stack();
    private OverthereFile srcDir;
    private static Logger logger = LoggerFactory.getLogger(OverthereFileCopier.class);

    private OverthereFileCopier(OverthereFile overthereFile, OverthereFile overthereFile2) {
        this.dstDirStack.push(overthereFile2);
        this.srcDir = overthereFile;
        OverthereFileCopier.checkDirectoryExists(overthereFile, SOURCE);
    }

    @Override
    protected void handleDirectoryStart(OverthereFile overthereFile, int n) throws IOException {
        OverthereFile overthereFile2 = this.getCurrentDestinationDir();
        if (n != 0) {
            overthereFile2 = this.createSubdirectoryAndMakeCurrent(overthereFile2, overthereFile.getName());
        }
        if (overthereFile2.exists()) {
            OverthereFileCopier.checkReallyIsADirectory(overthereFile2, DESTINATION);
            if (logger.isDebugEnabled()) {
                logger.debug("About to copy files into existing directory " + overthereFile2);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Creating destination directory " + overthereFile2);
            }
            overthereFile2.mkdir();
        }
    }

    private OverthereFile createSubdirectoryAndMakeCurrent(OverthereFile overthereFile, String string) {
        OverthereFile overthereFile2 = overthereFile.getFile(string);
        this.dstDirStack.push(overthereFile2);
        return overthereFile2;
    }

    private void startCopy() {
        this.walk(this.srcDir);
    }

    private OverthereFile getCurrentDestinationDir() {
        return this.dstDirStack.peek();
    }

    @Override
    protected void handleFile(OverthereFile overthereFile, int n) throws IOException {
        OverthereFile overthereFile2 = this.getCurrentDestinationDir().getFile(overthereFile.getName());
        OverthereFileCopier.copyFile(overthereFile, overthereFile2);
    }

    @Override
    protected void handleDirectoryEnd(OverthereFile overthereFile, int n) throws IOException {
        if (n != 0) {
            this.dstDirStack.pop();
        }
    }

    public static void copy(OverthereFile overthereFile, OverthereFile overthereFile2) {
        if (overthereFile.isDirectory()) {
            OverthereFileCopier.copyDirectory(overthereFile, overthereFile2);
        } else {
            OverthereFileCopier.copyFile(overthereFile, overthereFile2);
        }
    }

    private static void copyDirectory(OverthereFile overthereFile, OverthereFile overthereFile2) throws RuntimeIOException {
        OverthereFileCopier overthereFileCopier = new OverthereFileCopier(overthereFile, overthereFile2);
        overthereFileCopier.startCopy();
    }

    private static void copyFile(final OverthereFile overthereFile, final OverthereFile overthereFile2) throws RuntimeIOException {
        OverthereFileCopier.checkFileExists(overthereFile, SOURCE);
        OverthereFileCopier.checkReallyIsAFile(overthereFile2, DESTINATION);
        if (logger.isDebugEnabled()) {
            if (overthereFile2.exists()) {
                logger.debug("About to overwrite existing file " + overthereFile2);
            }
            logger.debug("Copying file " + overthereFile + " to " + overthereFile2);
        }
        try {
            ByteStreams.copy((InputSupplier)new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    return overthereFile.getInputStream();
                }
            }, (OutputSupplier)new OutputSupplier<OutputStream>(){

                public OutputStream getOutput() throws IOException {
                    return overthereFile2.getOutputStream();
                }
            });
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot copy " + overthereFile + " to " + overthereFile2, iOException);
        }
    }

    private static void checkFileExists(OverthereFile overthereFile, String string) {
        if (!overthereFile.exists()) {
            throw new RuntimeIOException(string + " file " + overthereFile + " does not exist");
        }
        OverthereFileCopier.checkReallyIsAFile(overthereFile, string);
    }

    private static void checkReallyIsAFile(OverthereFile overthereFile, String string) {
        if (overthereFile.exists() && overthereFile.isDirectory()) {
            throw new RuntimeIOException(string + " file " + overthereFile + " exists but is a directory");
        }
    }

    private static void checkDirectoryExists(OverthereFile overthereFile, String string) {
        if (!overthereFile.exists()) {
            throw new RuntimeIOException(string + " directory " + overthereFile + " does not exist");
        }
        OverthereFileCopier.checkReallyIsADirectory(overthereFile, string);
    }

    private static void checkReallyIsADirectory(OverthereFile overthereFile, String string) {
        if (overthereFile.exists() && !overthereFile.isDirectory()) {
            throw new RuntimeIOException(string + " directory " + overthereFile + " exists but is not a directory");
        }
    }
}

