/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.ssh.SshFile;
import com.xebialabs.overthere.ssh.SshScpConnection;
import com.xebialabs.overthere.util.CapturingOverthereProcessOutputHandler;
import com.xebialabs.overthere.util.LoggingOverthereProcessOutputHandler;
import com.xebialabs.overthere.util.MultipleOverthereProcessOutputHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.schmizz.sshj.xfer.LocalFileFilter;
import net.schmizz.sshj.xfer.LocalSourceFile;
import net.schmizz.sshj.xfer.scp.SCPUploadClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshScpFile
extends SshFile<SshScpConnection> {
    private Logger logger = LoggerFactory.getLogger(SshScpFile.class);

    public SshScpFile(SshScpConnection sshScpConnection, String string) {
        super(sshScpConnection, string);
    }

    @Override
    public boolean exists() {
        return this.getFileInfo().exists;
    }

    @Override
    public boolean canRead() {
        return this.getFileInfo().canRead;
    }

    @Override
    public boolean canWrite() {
        return this.getFileInfo().canWrite;
    }

    @Override
    public boolean canExecute() {
        return this.getFileInfo().canExecute;
    }

    @Override
    public boolean isFile() {
        return this.getFileInfo().isFile;
    }

    @Override
    public boolean isDirectory() {
        return this.getFileInfo().isDirectory;
    }

    @Override
    public long lastModified() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long length() {
        return this.getFileInfo().length;
    }

    public LsResults getFileInfo() throws RuntimeIOException {
        LsResults lsResults = new LsResults();
        CapturingOverthereProcessOutputHandler capturingOverthereProcessOutputHandler = CapturingOverthereProcessOutputHandler.capturingHandler();
        int n = this.executeCommand(capturingOverthereProcessOutputHandler, CmdLine.build("nocd", "ls", "-ld", this.getPath()));
        if (n == 0) {
            lsResults.exists = true;
            if (capturingOverthereProcessOutputHandler.getOutputLines().size() > 0) {
                StringTokenizer stringTokenizer;
                String string = capturingOverthereProcessOutputHandler.getOutputLines().get(capturingOverthereProcessOutputHandler.getOutputLines().size() - 1);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ls output = " + string);
                }
                if ((stringTokenizer = new StringTokenizer(string)).countTokens() < 5) {
                    throw new RuntimeIOException("ls -ld " + this.getPath() + " returned output that contains less than the expected 5 tokens: " + string);
                }
                String string2 = stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                lsResults.isFile = string2.length() >= 1 && string2.charAt(0) == '-';
                lsResults.isDirectory = string2.length() >= 1 && string2.charAt(0) == 'd';
                lsResults.canRead = string2.length() >= 2 && string2.charAt(1) == 'r';
                lsResults.canWrite = string2.length() >= 3 && string2.charAt(2) == 'w';
                lsResults.canExecute = string2.length() >= 4 && string2.charAt(3) == 'x';
                try {
                    lsResults.length = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    this.logger.warn("Cannot parse length of " + this.getPath() + " from ls output: " + string + ". Length will be reported as -1.", (Throwable)numberFormatException);
                }
            }
        } else {
            lsResults.exists = false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Listed file " + this + ": exists=" + lsResults.exists + ", isDirectory=" + lsResults.isDirectory + ", length=" + lsResults.length + ", canRead=" + lsResults.canRead + ", canWrite=" + lsResults.canWrite + ", canExecute=" + lsResults.canExecute);
        }
        return lsResults;
    }

    @Override
    public InputStream getInputStream() throws RuntimeIOException {
        try {
            final File file = File.createTempFile("scp_download", ".tmp");
            file.deleteOnExit();
            this.logger.debug("Downloading contents of {} to temporary file {}", (Object)this, (Object)file);
            ((SshScpConnection)this.connection).getSshClient().newSCPFileTransfer().download(this.getPath(), file.getPath());
            this.logger.debug("Opening input stream to temporary file {} to retrieve contents download from {}. Temporary file will be deleted when the stream is closed", (Object)file, (Object)this);
            return new FileInputStream(file){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        SshScpFile.this.logger.debug("Removing temporary file {}", (Object)file);
                        file.delete();
                    }
                }
            };
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot open " + this + " for reading: " + iOException.toString(), iOException);
        }
    }

    @Override
    public OutputStream getOutputStream() throws RuntimeIOException {
        try {
            final File file = File.createTempFile("scp_upload", ".tmp");
            file.deleteOnExit();
            this.logger.debug("Opening output stream to temporary file {} to store contents to be uploaded to {} when the stream is closed", (Object)file, (Object)this);
            return new FileOutputStream(file){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        this.uploadAndDelete(file);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void uploadAndDelete(File file2) throws IOException {
                    SshScpFile.this.logger.debug("Uploading contents of temporary file {} to to {}", (Object)file2, (Object)this);
                    try {
                        ((SshScpConnection)SshScpFile.this.connection).getSshClient().newSCPFileTransfer().upload(file2.getPath(), SshScpFile.this.getPath());
                    }
                    finally {
                        SshScpFile.this.logger.debug("Removing temporary file {}", (Object)file2);
                        file2.delete();
                    }
                }
            };
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot open " + this + " for reading: " + iOException.toString(), iOException);
        }
    }

    @Override
    public List<OverthereFile> listFiles() {
        this.logger.debug("Listing directory {}", (Object)this);
        CapturingOverthereProcessOutputHandler capturingOverthereProcessOutputHandler = CapturingOverthereProcessOutputHandler.capturingHandler();
        int n = this.executeCommand(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), capturingOverthereProcessOutputHandler), CmdLine.build("nocd", "ls", "-1", this.getPath()));
        if (n != 0) {
            throw new RuntimeIOException("Cannot list directory " + this + ": " + capturingOverthereProcessOutputHandler.getError() + " (errno=" + n + ")");
        }
        ArrayList arrayList = Lists.newArrayList();
        for (String string : capturingOverthereProcessOutputHandler.getOutputLines()) {
            arrayList.add(((SshScpConnection)this.connection).getFile(this, string));
        }
        return arrayList;
    }

    @Override
    public void mkdir() {
        this.logger.debug("Creating directory {}", (Object)this);
        this.mkdir(new String[0]);
    }

    @Override
    public void mkdirs() {
        this.logger.debug("Creating directories {}", (Object)this);
        this.mkdir("-p");
    }

    protected void mkdir(String ... stringArray) throws RuntimeIOException {
        CmdLine cmdLine = CmdLine.build("nocd", "mkdir");
        for (String string : stringArray) {
            cmdLine.addArgument(string);
        }
        cmdLine.addArgument(this.getPath());
        CapturingOverthereProcessOutputHandler capturingOverthereProcessOutputHandler = CapturingOverthereProcessOutputHandler.capturingHandler();
        int n = this.executeCommand(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), capturingOverthereProcessOutputHandler), cmdLine);
        if (n != 0) {
            throw new RuntimeIOException("Cannot create directory or -ies " + this + ": " + capturingOverthereProcessOutputHandler.getError() + " (errno=" + n + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Created directory " + this + " (with options:" + Joiner.on((char)' ').join((Object[])stringArray));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void renameTo(OverthereFile overthereFile) {
        this.logger.debug("Renaming {} to {}", (Object)this, (Object)overthereFile);
        if (!(overthereFile instanceof SshScpFile)) throw new RuntimeIOException("Cannot rename :ssh:" + ((SshScpConnection)this.connection).sshConnectionType.toString().toLowerCase() + ": file/directory " + this + " to non-:ssh:" + ((SshScpConnection)this.connection).sshConnectionType.toString().toLowerCase() + ": file/directory " + overthereFile);
        SshScpFile sshScpFile = (SshScpFile)overthereFile;
        if (sshScpFile.getConnection() != this.getConnection()) throw new RuntimeIOException("Cannot rename :ssh:" + ((SshScpConnection)this.connection).sshConnectionType.toString().toLowerCase() + ": file/directory " + this + " to file/directory " + overthereFile + " because it is in a different connection");
        CapturingOverthereProcessOutputHandler capturingOverthereProcessOutputHandler = CapturingOverthereProcessOutputHandler.capturingHandler();
        int n = this.executeCommand(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), capturingOverthereProcessOutputHandler), CmdLine.build("nocd", "mv", this.getPath(), sshScpFile.getPath()));
        if (n == 0) return;
        throw new RuntimeIOException("Cannot rename file/directory " + this + ": " + capturingOverthereProcessOutputHandler.getError() + " (errno=" + n + ")");
    }

    @Override
    public void setExecutable(boolean bl) {
        this.logger.debug("Setting execute permission on {} to {}", (Object)this, (Object)bl);
        CapturingOverthereProcessOutputHandler capturingOverthereProcessOutputHandler = CapturingOverthereProcessOutputHandler.capturingHandler();
        int n = this.executeCommand(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), capturingOverthereProcessOutputHandler), CmdLine.build("nocd", "chmod", bl ? "a+x" : "a-x", this.getPath()));
        if (n != 0) {
            throw new RuntimeIOException("Cannot set execute permission on file " + this + " to " + bl + ": " + capturingOverthereProcessOutputHandler.getError() + " (errno=" + n + ")");
        }
    }

    @Override
    protected void deleteDirectory() {
        this.logger.debug("Deleting directory {}", (Object)this);
        CapturingOverthereProcessOutputHandler capturingOverthereProcessOutputHandler = CapturingOverthereProcessOutputHandler.capturingHandler();
        int n = this.executeCommand(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), capturingOverthereProcessOutputHandler), CmdLine.build("nocd", "rmdir", this.getPath()));
        if (n != 0) {
            throw new RuntimeIOException("Cannot delete directory " + this + ": " + capturingOverthereProcessOutputHandler.getError() + " (errno=" + n + ")");
        }
    }

    @Override
    protected void deleteFile() {
        this.logger.debug("Deleting file {}", (Object)this);
        CapturingOverthereProcessOutputHandler capturingOverthereProcessOutputHandler = CapturingOverthereProcessOutputHandler.capturingHandler();
        int n = this.executeCommand(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), capturingOverthereProcessOutputHandler), CmdLine.build("nocd", "rm", "-f", this.getPath()));
        if (n != 0) {
            throw new RuntimeIOException("Cannot delete file " + this + ": " + capturingOverthereProcessOutputHandler.getError() + " (errno=" + n + ")");
        }
    }

    @Override
    public void deleteRecursively() throws RuntimeIOException {
        this.logger.debug("Recursively deleting file or directory {}", (Object)this);
        CapturingOverthereProcessOutputHandler capturingOverthereProcessOutputHandler = CapturingOverthereProcessOutputHandler.capturingHandler();
        int n = this.executeCommand(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), capturingOverthereProcessOutputHandler), CmdLine.build("nocd", "rm", "-rf", this.getPath()));
        if (n != 0) {
            throw new RuntimeIOException("Cannot recursively delete file or directory " + this + ": " + capturingOverthereProcessOutputHandler.getError() + " (errno=" + n + ")");
        }
    }

    @Override
    protected void copyFrom(OverthereFile overthereFile) {
        this.logger.debug("Copying file or directory {} to {}", (Object)overthereFile, (Object)this);
        SCPUploadClient sCPUploadClient = ((SshScpConnection)this.connection).getSshClient().newSCPFileTransfer().newSCPUploadClient();
        try {
            if (overthereFile.isDirectory() && this.exists()) {
                for (OverthereFile overthereFile2 : overthereFile.listFiles()) {
                    sCPUploadClient.copy((LocalSourceFile)new OverthereFileLocalSourceFile(overthereFile2), this.getPath());
                }
            } else {
                sCPUploadClient.copy((LocalSourceFile)new OverthereFileLocalSourceFile(overthereFile), this.getPath());
            }
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Cannot copy " + overthereFile + " to " + this + ": " + iOException.toString(), iOException);
        }
    }

    protected static class OverthereFileLocalSourceFile
    implements LocalSourceFile {
        private OverthereFile f;

        public OverthereFileLocalSourceFile(OverthereFile overthereFile) {
            this.f = overthereFile;
        }

        public String getName() {
            return this.f.getName();
        }

        public long getLength() {
            return this.f.length();
        }

        public InputStream getInputStream() throws IOException {
            return this.f.getInputStream();
        }

        public int getPermissions() throws IOException {
            return this.f.isDirectory() ? 493 : 420;
        }

        public boolean isFile() {
            return this.f.isFile();
        }

        public boolean isDirectory() {
            return this.f.isDirectory();
        }

        public Iterable<? extends LocalSourceFile> getChildren(LocalFileFilter localFileFilter) throws IOException {
            ArrayList arrayList = Lists.newArrayList();
            for (OverthereFile overthereFile : this.f.listFiles()) {
                arrayList.add(new OverthereFileLocalSourceFile(overthereFile));
            }
            return arrayList;
        }

        public boolean providesAtimeMtime() {
            return false;
        }

        public long getLastAccessTime() throws IOException {
            return 0L;
        }

        public long getLastModifiedTime() throws IOException {
            return 0L;
        }
    }

    public static class LsResults {
        public boolean exists;
        public boolean isFile;
        public boolean isDirectory;
        public long length = -1L;
        public boolean canRead;
        public boolean canWrite;
        public boolean canExecute;
    }
}

