/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.container;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.ci.NestedContainer;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.generic.step.WaitStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class LifeCycleContributor {
    @Contributor
    public void restartContainers(Deltas deltas, DeploymentPlanningContext deploymentPlanningContext) {
        Set<Container> set = this.gatherTargets(deltas.getDeltas());
        for (Container container : set) {
            if (!Strings.nullToEmpty((String)container.getRestartScript()).trim().isEmpty()) {
                this.addStep(container.getRestartScript(), container.getRestartOrder(), container, "Restart", deploymentPlanningContext);
                this.addWaitStep(container.getRestartWaitTime(), container.getRestartOrder(), container, "restart", deploymentPlanningContext);
                continue;
            }
            Preconditions.checkArgument((!Strings.nullToEmpty((String)container.getStartScript()).trim().isEmpty() ? 1 : 0) != 0, (Object)"start script must be specified when no restart script defined.");
            Preconditions.checkArgument((!Strings.nullToEmpty((String)container.getStopScript()).trim().isEmpty() ? 1 : 0) != 0, (Object)"stop script must be specified when no restart script defined.");
            this.addStep(container.getStartScript(), container.getStartOrder(), container, "Start", deploymentPlanningContext);
            this.addWaitStep(container.getStartWaitTime(), container.getStartOrder(), container, "start", deploymentPlanningContext);
            this.addStep(container.getStopScript(), container.getStopOrder(), container, "Stop", deploymentPlanningContext);
            this.addWaitStep(container.getStopWaitTime(), container.getStopOrder(), container, "stop", deploymentPlanningContext);
        }
    }

    private void addWaitStep(int n, int n2, Container container, String string, DeploymentPlanningContext deploymentPlanningContext) {
        if (n > 0) {
            deploymentPlanningContext.addStep((DeploymentStep)new WaitStep(n2 + 1, n, container.getName(), string));
        }
    }

    private void addStep(String string, int n, Container container, String string2, DeploymentPlanningContext deploymentPlanningContext) {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("container", container);
        deploymentPlanningContext.addStep((DeploymentStep)new ScriptExecutionStep(n, string, container, hashMap, this.getDescription(string2, container)));
    }

    private String getDescription(String string, Container container) {
        return String.format("%s %s", string, container.getName());
    }

    private Set<Container> gatherTargets(List<Delta> list) {
        TreeSet treeSet = Sets.newTreeSet();
        for (Delta delta : list) {
            this.addTarget(treeSet, delta.getOperation(), delta.getDeployed());
            this.addTarget(treeSet, delta.getOperation(), delta.getPrevious());
        }
        return treeSet;
    }

    private void addTarget(Set<Container> set, Operation operation, Deployed<?, ?> deployed) {
        AbstractDeployed abstractDeployed;
        boolean bl;
        if (deployed == null) {
            return;
        }
        if (deployed instanceof AbstractDeployed && (bl = (abstractDeployed = (AbstractDeployed)deployed).isRestartRequired())) {
            if (operation != Operation.NOOP) {
                set.add(this.getRootContainer((HostContainer)deployed.getContainer()));
            } else if (abstractDeployed.isRestartRequiredForNoop()) {
                set.add(this.getRootContainer((HostContainer)deployed.getContainer()));
            }
        }
    }

    private Container getRootContainer(HostContainer hostContainer) {
        if (hostContainer instanceof Container) {
            return (Container)hostContainer;
        }
        if (hostContainer instanceof NestedContainer) {
            return ((NestedContainer)hostContainer).getRootContainer();
        }
        throw new IllegalStateException("The root container for a nested container not found. NestedContains should be rooted to a generic Container.");
    }
}

