/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel.direct;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import net.schmizz.concurrent.Event;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.SocketStreamCopyMonitor;
import net.schmizz.sshj.connection.channel.direct.AbstractDirectChannel;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPortForwarder {
    private final Logger log = LoggerFactory.getLogger(LocalPortForwarder.class);
    private final Connection conn;
    private final Parameters parameters;
    private final ServerSocket serverSocket;

    public LocalPortForwarder(Connection conn, Parameters parameters, ServerSocket serverSocket) {
        this.conn = conn;
        this.parameters = parameters;
        this.serverSocket = serverSocket;
    }

    protected DirectTCPIPChannel openChannel(Socket socket) throws TransportException, ConnectionException {
        DirectTCPIPChannel chan = new DirectTCPIPChannel(this.conn, socket, this.parameters);
        chan.open();
        return chan;
    }

    public void listen() throws IOException {
        this.log.info("Listening on {}", (Object)this.serverSocket.getLocalSocketAddress());
        while (!Thread.currentThread().isInterrupted()) {
            Socket socket = this.serverSocket.accept();
            this.log.info("Got connection from {}", (Object)socket.getRemoteSocketAddress());
            this.openChannel(socket).start();
        }
        this.log.info("Interrupted!");
    }

    public static class DirectTCPIPChannel
    extends AbstractDirectChannel {
        protected final Socket socket;
        protected final Parameters parameters;

        public DirectTCPIPChannel(Connection conn, Socket socket, Parameters parameters) {
            super(conn, "direct-tcpip");
            this.socket = socket;
            this.parameters = parameters;
        }

        protected void start() throws IOException {
            this.socket.setSendBufferSize(this.getLocalMaxPacketSize());
            this.socket.setReceiveBufferSize(this.getRemoteMaxPacketSize());
            Event<IOException> soc2chan = new StreamCopier(this.socket.getInputStream(), this.getOutputStream()).bufSize(this.getRemoteMaxPacketSize()).spawnDaemon("soc2chan");
            Event<IOException> chan2soc = new StreamCopier(this.getInputStream(), this.socket.getOutputStream()).bufSize(this.getLocalMaxPacketSize()).spawnDaemon("chan2soc");
            SocketStreamCopyMonitor.monitor(5, TimeUnit.SECONDS, soc2chan, chan2soc, this, this.socket);
        }

        @Override
        protected SSHPacket buildOpenReq() {
            return (SSHPacket)((SSHPacket)((SSHPacket)((SSHPacket)super.buildOpenReq().putString(this.parameters.getRemoteHost())).putUInt32(this.parameters.getRemotePort())).putString(this.parameters.getLocalHost())).putUInt32(this.parameters.getLocalPort());
        }
    }

    public static class Parameters {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;

        public Parameters(String localHost, int localPort, String remoteHost, int remotePort) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
        }

        public String getRemoteHost() {
            return this.remoteHost;
        }

        public int getRemotePort() {
            return this.remotePort;
        }

        public String getLocalHost() {
            return this.localHost;
        }

        public int getLocalPort() {
            return this.localPort;
        }
    }
}

