/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.python;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionExecutionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionStep;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.python.PythonStep;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonInspectionStep
extends PythonStep<InspectionExecutionContext>
implements InspectionStep {
    private static final String defaultEncoding = "UTF-8";
    protected ConfigurationItem inspectedItem;
    protected Descriptor inspectedItemDescriptor;
    public static final String INSPECTED_PROPERTY_PRELUDE = "INSPECTED:";
    public static final String DISCOVERED_ITEM_PRELUDE = "DISCOVERED:";
    private static Logger logger = LoggerFactory.getLogger(PythonInspectionStep.class);

    public PythonInspectionStep(ConfigurationItem configurationItem, PythonManagingContainer pythonManagingContainer, String string, Map<String, Object> map, String string2) {
        super(pythonManagingContainer, string, map, string2);
        this.inspectedItem = configurationItem;
        this.inspectedItemDescriptor = DescriptorRegistry.getDescriptor((Type)configurationItem.getType());
    }

    public Step.Result execute(final InspectionExecutionContext inspectionExecutionContext) throws Exception {
        Step.Result result = this.doExecute((ExecutionContext)new InspectionExecutionContext(){

            public void logOutput(String string) {
                if (PythonInspectionStep.this.handleOutputLine(string, inspectionExecutionContext)) {
                    logger.trace("Handled inspection protocol line {}", (Object)string);
                } else {
                    inspectionExecutionContext.logOutput(string);
                }
            }

            public void logError(String string) {
                inspectionExecutionContext.logError(string);
            }

            public void logError(String string, Throwable throwable) {
                inspectionExecutionContext.logError(string, throwable);
            }

            public Object getAttribute(String string) {
                return inspectionExecutionContext.getAttribute(string);
            }

            public void setAttribute(String string, Object object) {
                inspectionExecutionContext.setAttribute(string, object);
            }

            public void discovered(ConfigurationItem configurationItem) {
                inspectionExecutionContext.discovered(configurationItem);
            }
        });
        return result;
    }

    protected boolean handleOutputLine(String string, InspectionExecutionContext inspectionExecutionContext) {
        int n = string.indexOf(61);
        if (n < 0) {
            return false;
        }
        try {
            if (string.startsWith(INSPECTED_PROPERTY_PRELUDE)) {
                String string2 = URLDecoder.decode(string.substring(INSPECTED_PROPERTY_PRELUDE.length(), n), defaultEncoding);
                String string3 = string.substring(n + 1);
                return this.handleInspectedProperty(string2, string3, inspectionExecutionContext);
            }
            if (string.startsWith(DISCOVERED_ITEM_PRELUDE)) {
                String string4 = URLDecoder.decode(string.substring(DISCOVERED_ITEM_PRELUDE.length(), n), defaultEncoding);
                String string5 = string.substring(n + 1);
                return this.handleDiscoveredItem(string4, string5, inspectionExecutionContext);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.debug("Unsupported encoding exception was encountered while parsing inspected and / or discovered items");
            return false;
        }
        return false;
    }

    private boolean handleInspectedProperty(String string, String string2, InspectionExecutionContext inspectionExecutionContext) throws UnsupportedEncodingException {
        PropertyDescriptor propertyDescriptor = this.inspectedItemDescriptor.getPropertyDescriptor(string);
        if (propertyDescriptor == null) {
            inspectionExecutionContext.logError("Inspected unknown property " + string);
            return false;
        }
        PropertyKind propertyKind = propertyDescriptor.getKind();
        if (propertyKind == PropertyKind.SET_OF_CI) {
            HashSet hashSet = Sets.newHashSet(this.getCis(string2, propertyDescriptor));
            propertyDescriptor.set(this.inspectedItem, (Object)hashSet);
        } else if (propertyKind == PropertyKind.SET_OF_STRING) {
            HashSet hashSet = Sets.newHashSet(this.getStrings(string2));
            propertyDescriptor.set(this.inspectedItem, (Object)hashSet);
        } else if (propertyKind == PropertyKind.LIST_OF_CI) {
            ArrayList arrayList = Lists.newArrayList(this.getCis(string2, propertyDescriptor));
            propertyDescriptor.set(this.inspectedItem, (Object)arrayList);
        } else if (propertyKind == PropertyKind.LIST_OF_STRING) {
            ArrayList arrayList = Lists.newArrayList(this.getStrings(string2));
            propertyDescriptor.set(this.inspectedItem, (Object)arrayList);
        } else if (propertyKind == PropertyKind.MAP_STRING_STRING) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (!string2.isEmpty()) {
                for (String string3 : string2.split(",")) {
                    if (!string3.contains(":")) continue;
                    String[] stringArray = string3.split(":");
                    hashMap.put(URLDecoder.decode(stringArray[0], defaultEncoding), URLDecoder.decode(stringArray[1], defaultEncoding));
                }
            }
            propertyDescriptor.set(this.inspectedItem, hashMap);
        } else {
            propertyDescriptor.set(this.inspectedItem, (Object)URLDecoder.decode(string2, defaultEncoding));
        }
        logger.debug("Inspected property {} with value {}", (Object)string, (Object)string2);
        return true;
    }

    private Collection<String> getStrings(String string) throws UnsupportedEncodingException {
        ArrayList arrayList = Lists.newArrayList();
        if (!string.isEmpty()) {
            for (String string2 : string.split(",")) {
                arrayList.add(URLDecoder.decode(string2, defaultEncoding));
            }
        }
        return arrayList;
    }

    private Collection<ConfigurationItem> getCis(String string, PropertyDescriptor propertyDescriptor) throws UnsupportedEncodingException {
        ArrayList arrayList = Lists.newArrayList();
        if (!string.isEmpty()) {
            Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)propertyDescriptor.getReferencedType());
            for (String string2 : string.split(",")) {
                ConfigurationItem configurationItem = descriptor.newInstance();
                configurationItem.setId(URLDecoder.decode(string2, defaultEncoding));
                arrayList.add(configurationItem);
            }
        }
        return arrayList;
    }

    private boolean handleDiscoveredItem(String string, String string2, InspectionExecutionContext inspectionExecutionContext) throws UnsupportedEncodingException {
        Type type = Type.valueOf((String)URLDecoder.decode(string2, defaultEncoding));
        if (!DescriptorRegistry.exists((Type)type)) {
            inspectionExecutionContext.logError("Discovered item " + string + " of unknown type " + type);
            return false;
        }
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)type);
        ConfigurationItem configurationItem = descriptor.newInstance();
        configurationItem.setId(string);
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            if (!this.isReferenceToParent(propertyDescriptor)) continue;
            propertyDescriptor.set(configurationItem, (Object)this.inspectedItem);
        }
        inspectionExecutionContext.discovered(configurationItem);
        logger.debug("Discovered item {} with type {}", (Object)string, (Object)type);
        return true;
    }

    protected boolean isReferenceToParent(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getKind() == PropertyKind.CI && propertyDescriptor.isAsContainment() && this.inspectedItemDescriptor.isAssignableTo(propertyDescriptor.getReferencedType());
    }
}

