/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.BaseParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFObjectStreamParser
extends BaseParser {
    private static final Log log = LogFactory.getLog(PDFObjectStreamParser.class);
    private List<COSObject> streamObjects = null;
    private List<Integer> objectNumbers = null;
    private COSStream stream;

    public PDFObjectStreamParser(COSStream strm, COSDocument doc, boolean forceParsing) throws IOException {
        super(strm.getUnfilteredStream(), forceParsing);
        this.setDocument(doc);
        this.stream = strm;
    }

    public PDFObjectStreamParser(COSStream strm, COSDocument doc) throws IOException {
        this(strm, doc, FORCE_PARSING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        try {
            int numberOfObjects = this.stream.getInt("N");
            this.objectNumbers = new ArrayList<Integer>(numberOfObjects);
            this.streamObjects = new ArrayList<COSObject>(numberOfObjects);
            for (int i = 0; i < numberOfObjects; ++i) {
                int objectNumber = this.readInt();
                int offset = this.readInt();
                this.objectNumbers.add(new Integer(objectNumber));
            }
            COSObject object = null;
            COSBase cosObject = null;
            int objectCounter = 0;
            while ((cosObject = this.parseDirObject()) != null) {
                object = new COSObject(cosObject);
                object.setGenerationNumber(COSInteger.ZERO);
                COSInteger objNum = COSInteger.get(this.objectNumbers.get(objectCounter).intValue());
                object.setObjectNumber(objNum);
                this.streamObjects.add(object);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("parsed=" + object));
                }
                ++objectCounter;
            }
        }
        finally {
            this.pdfSource.close();
        }
    }

    public List<COSObject> getObjects() {
        return this.streamObjects;
    }
}

