/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key.pbe.swing;

import de.schlichtherle.truezip.key.pbe.swing.BasicInvalidKeyFeedback;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class HurlingWindowFeedback
extends BasicInvalidKeyFeedback {
    private static final double PI = Math.PI;
    private static final double TWO_PI = Math.PI * 2;
    public static final int AMPLITUDE = 25;
    public static final int CYCLE = 150;
    public static final int DURATION = 1500;
    public static final int FPS = 75;
    private final double amplitude;
    private final double cycle;
    private final int duration;
    private final int fps;

    public HurlingWindowFeedback() {
        this(25, 150, 1500, 75);
    }

    protected HurlingWindowFeedback(int amplitude, int cycle, int duration, int fps) {
        super(duration > 3000 ? duration : 3000);
        this.amplitude = amplitude;
        this.cycle = cycle;
        this.duration = duration;
        this.fps = fps;
    }

    @Override
    public void run(@NonNull JPanel panel) {
        final Window window = SwingUtilities.getWindowAncestor(panel);
        super.run(panel);
        if (null == window) {
            return;
        }
        final Point origin = window.getLocation();
        final long start = System.currentTimeMillis();
        Timer timer = new Timer(1000 / this.fps, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long elapsed = System.currentTimeMillis() - start;
                if (elapsed < (long)HurlingWindowFeedback.this.duration && window.isShowing()) {
                    double angle = Math.PI * 2 * (double)elapsed / HurlingWindowFeedback.this.cycle;
                    double offset = Math.sin(Math.PI * (double)elapsed / (double)HurlingWindowFeedback.this.duration) * HurlingWindowFeedback.this.amplitude;
                    int x = (int)(Math.cos(angle) * offset + (double)origin.x);
                    int y = (int)(Math.sin(angle) * offset + (double)origin.y);
                    window.setLocation(x, y);
                    window.repaint();
                } else {
                    ((Timer)e.getSource()).stop();
                    window.setLocation(origin);
                    window.repaint();
                }
            }
        });
        timer.start();
    }
}

