/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.OutputClosedException;
import de.schlichtherle.truezip.socket.DecoratingOutputShop;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class DisconnectingOutputShop<E extends Entry>
extends DecoratingOutputShop<E, OutputShop<E>> {
    private boolean closed;

    public DisconnectingOutputShop(OutputShop<E> output) {
        super(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            ((OutputShop)this.delegate).close();
        }
        finally {
            this.closed = true;
        }
    }

    private void assertNotClosed() throws IOException {
        if (this.closed) {
            throw new OutputClosedException();
        }
    }

    @Override
    public final OutputSocket<? extends E> getOutputSocket(E entry) {
        if (null == entry) {
            throw new NullPointerException();
        }
        class Output
        extends DecoratingOutputSocket<E> {
            final /* synthetic */ Entry val$entry;

            Output() {
                this.val$entry = entry;
                super(DisconnectingOutputShop.super.getOutputSocket(entry));
            }

            @Override
            public OutputStream newOutputStream() throws IOException {
                DisconnectingOutputShop.this.assertNotClosed();
                return new DisconnectableOutputStream(this.getBoundSocket().newOutputStream());
            }
        }
        return new Output();
    }

    private final class DisconnectableOutputStream
    extends DecoratingOutputStream {
        DisconnectableOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            DisconnectingOutputShop.this.assertNotClosed();
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            DisconnectingOutputShop.this.assertNotClosed();
            this.delegate.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            if (!DisconnectingOutputShop.this.closed) {
                this.delegate.flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (DisconnectingOutputShop.this.closed) {
                return;
            }
            this.delegate.close();
        }
    }
}

