/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.rof;

import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public class IntervalReadOnlyFile
extends DecoratingReadOnlyFile {
    private final long start;
    private final long length;
    private final boolean exclusive;
    private long fp;

    public IntervalReadOnlyFile(ReadOnlyFile rof, long length) throws IOException {
        this(rof, rof.getFilePointer(), length, true);
    }

    public IntervalReadOnlyFile(@Nullable ReadOnlyFile rof, long start, long length) throws IOException {
        this(rof, start, length, false);
    }

    private IntervalReadOnlyFile(@Nullable ReadOnlyFile rof, long start, long length, boolean exclusive) throws IOException {
        super(rof);
        if (start < 0L || length < 0L || rof.length() < start + length) {
            throw new IllegalArgumentException();
        }
        this.start = start;
        this.length = length;
        this.exclusive = exclusive;
    }

    @Override
    public long length() throws IOException {
        long length = this.length;
        if (this.delegate.length() < this.start + length) {
            throw new IOException("Read Only File has been changed!");
        }
        return length;
    }

    @Override
    public long getFilePointer() throws IOException {
        this.delegate.getFilePointer();
        return this.fp;
    }

    @Override
    public void seek(long fp) throws IOException {
        if (fp < 0L) {
            throw new IOException("File pointer must not be negative!");
        }
        long length = this.length;
        if (fp > length) {
            throw new IOException("File pointer (" + fp + ") is larger than file length (" + length + ")!");
        }
        this.delegate.seek(fp + this.start);
        this.fp = fp;
    }

    @Override
    public int read() throws IOException {
        long fp = this.fp;
        if (fp >= this.length) {
            return -1;
        }
        if (!this.exclusive) {
            this.delegate.seek(fp + this.start);
        }
        int read = this.delegate.read();
        this.fp = fp + 1L;
        return read;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (0 == len) {
            return 0;
        }
        if (0 > (off | len | buf.length - off - len)) {
            throw new IndexOutOfBoundsException();
        }
        long fp = this.fp;
        long length = this.length;
        if (fp + (long)len > length) {
            len = (int)(length - fp);
        }
        if (!this.exclusive) {
            this.delegate.seek(fp + this.start);
        }
        int read = this.delegate.read(buf, off, len);
        if (0 == len) {
            assert (0 >= read);
            return -1;
        }
        assert (0 < read);
        this.fp = fp + (long)read;
        return read;
    }

    @Override
    public void close() throws IOException {
        if (this.exclusive) {
            this.delegate.close();
        }
    }
}

