/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.FsCharsetArchiveDriver;
import de.schlichtherle.truezip.fs.archive.FsMultiplexedOutputShop;
import de.schlichtherle.truezip.fs.archive.zip.KeyManagerZipCryptoParameters;
import de.schlichtherle.truezip.fs.archive.zip.KeyProviderSyncStrategy;
import de.schlichtherle.truezip.fs.archive.zip.OptionOutputSocket;
import de.schlichtherle.truezip.fs.archive.zip.ZipArchiveEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipController;
import de.schlichtherle.truezip.fs.archive.zip.ZipInputShop;
import de.schlichtherle.truezip.fs.archive.zip.ZipOutputShop;
import de.schlichtherle.truezip.key.KeyManagerProvider;
import de.schlichtherle.truezip.key.sl.KeyManagerLocator;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.zip.ZipCryptoParameters;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipFileParameters;
import de.schlichtherle.truezip.zip.ZipOutputStreamParameters;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public class ZipDriver
extends FsCharsetArchiveDriver<ZipArchiveEntry>
implements ZipOutputStreamParameters,
ZipFileParameters<ZipArchiveEntry> {
    private static final Logger logger = Logger.getLogger(ZipDriver.class.getName(), ZipDriver.class.getName());
    private static final Charset ZIP_CHARSET = Charset.forName("IBM437");
    private final IOPool<?> ioPool;

    public ZipDriver(IOPoolProvider ioPoolProvider) {
        this(ioPoolProvider, ZIP_CHARSET);
    }

    protected ZipDriver(IOPoolProvider ioPoolProvider, Charset charset) {
        super(charset);
        this.ioPool = ioPoolProvider.get();
    }

    protected KeyProviderSyncStrategy getKeyProviderSyncStrategy() {
        return KeyProviderSyncStrategy.RESET_CANCELLED_KEY;
    }

    protected KeyManagerProvider getKeyManagerProvider() {
        return KeyManagerLocator.SINGLETON;
    }

    @CheckForNull
    final ZipCryptoParameters zipCryptoParameters(ZipInputShop input) {
        return this.zipCryptoParameters(input.getModel(), input.getRawCharset());
    }

    @CheckForNull
    final ZipCryptoParameters zipCryptoParameters(ZipOutputShop output) {
        return this.zipCryptoParameters(output.getModel(), output.getRawCharset());
    }

    @CheckForNull
    protected ZipCryptoParameters zipCryptoParameters(FsModel model, Charset charset) {
        return new KeyManagerZipCryptoParameters(this, model, charset);
    }

    public URI mountPointUri(FsModel model) {
        return model.getMountPoint().toHierarchicalUri();
    }

    public URI resourceUri(FsModel model, String name) {
        return this.mountPointUri(model);
    }

    public boolean getRedundantContentSupport() {
        return true;
    }

    public boolean getRedundantMetaDataSupport() {
        return true;
    }

    protected boolean check(ZipInputShop input, ZipArchiveEntry entry) {
        return entry.isEncrypted();
    }

    final boolean process(ZipInputShop input, ZipArchiveEntry local, ZipArchiveEntry peer) {
        return this.process(local, peer);
    }

    final boolean process(ZipOutputShop output, ZipArchiveEntry local, ZipArchiveEntry peer) {
        return this.process(peer, local);
    }

    protected boolean process(ZipArchiveEntry input, ZipArchiveEntry output) {
        return input.isEncrypted() || output.isEncrypted();
    }

    protected final IOPool<?> getPool() {
        return this.ioPool;
    }

    @Override
    public boolean getPreambled() {
        return false;
    }

    @Override
    public boolean getPostambled() {
        return false;
    }

    @Override
    @Deprecated
    public int getOverheadSize() {
        return 64;
    }

    @Override
    public int getMethod() {
        return 8;
    }

    @Override
    public int getLevel() {
        return 9;
    }

    public FsController<?> newController(FsModel model, FsController<?> parent) {
        return new ZipController(this.superNewController(model, parent), this);
    }

    protected final FsController<?> superNewController(FsModel model, FsController<?> parent) {
        return super.newController(model, parent);
    }

    public ZipArchiveEntry newEntry(String name, Entry.Type type, Entry template, BitField<FsOutputOption> mknod) throws CharConversionException {
        ZipArchiveEntry entry;
        this.assertEncodable(name);
        name = ZipDriver.toZipOrTarEntryName((String)name, (Entry.Type)type);
        if (template instanceof ZipEntry) {
            entry = this.newEntry(name, (ZipEntry)template);
        } else {
            entry = this.newEntry(name);
            if (null != template) {
                entry.setTime(template.getTime(Entry.Access.WRITE));
                entry.setSize(template.getSize(Entry.Size.DATA));
            }
        }
        if (mknod.get((Enum)FsOutputOption.STORE)) {
            entry.setMethod(0);
        }
        if (Entry.Type.DIRECTORY != type) {
            if (-1 == entry.getMethod()) {
                int method = this.getMethod();
                entry.setMethod(method);
                if (0 != method) {
                    entry.setCompressedSize(-1L);
                }
            }
            if (mknod.get((Enum)FsOutputOption.ENCRYPT)) {
                entry.setEncrypted(true);
            }
        }
        return entry;
    }

    @Override
    public ZipArchiveEntry newEntry(String name) {
        return new ZipArchiveEntry(name);
    }

    public ZipArchiveEntry newEntry(String name, ZipEntry template) {
        return new ZipArchiveEntry(name, template);
    }

    public InputShop<ZipArchiveEntry> newInputShop(FsModel model, InputSocket<?> input) throws IOException {
        ReadOnlyFile rof = input.newReadOnlyFile();
        try {
            return this.newInputShop(model, rof);
        }
        catch (IOException ex) {
            rof.close();
            throw ex;
        }
    }

    protected InputShop<ZipArchiveEntry> newInputShop(FsModel model, ReadOnlyFile rof) throws IOException {
        ZipInputShop input = new ZipInputShop(this, model, rof);
        try {
            input.recoverLostEntries();
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "junkInTheTrunk.warning", new Object[]{this.mountPointUri(model), input.getPostambleLength()});
            logger.log(Level.FINE, "junkInTheTrunk.fine", ex);
        }
        return input;
    }

    public OptionOutputSocket getOutputSocket(FsController<?> controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        if ((options = options.set((Enum)FsOutputOption.STORE)).get((Enum)FsOutputOption.GROW)) {
            options = options.set((Enum)FsOutputOption.APPEND).clear((Enum)FsOutputOption.CACHE);
        }
        return new OptionOutputSocket(controller.getOutputSocket(name, options, template), (BitField<FsOutputOption>)options);
    }

    public final OutputShop<ZipArchiveEntry> newOutputShop(FsModel model, OutputSocket<?> output, @CheckForNull InputShop<ZipArchiveEntry> source) throws IOException {
        return this.newOutputShop0(model, (OptionOutputSocket)output, (ZipInputShop)source);
    }

    private OutputShop<ZipArchiveEntry> newOutputShop0(FsModel model, OptionOutputSocket output, @CheckForNull ZipInputShop source) throws IOException {
        BitField<FsOutputOption> options = output.getOptions();
        if (null != source) {
            source.setAppendee(options.get((Enum)FsOutputOption.GROW));
        }
        return this.newOutputShop(model, output, source);
    }

    protected OutputShop<ZipArchiveEntry> newOutputShop(FsModel model, OptionOutputSocket output, @CheckForNull ZipInputShop source) throws IOException {
        OutputStream out = output.newOutputStream();
        try {
            return this.newOutputShop(model, out, source);
        }
        catch (IOException ex) {
            out.close();
            throw ex;
        }
    }

    protected OutputShop<ZipArchiveEntry> newOutputShop(FsModel model, OutputStream out, @CheckForNull ZipInputShop source) throws IOException {
        return new FsMultiplexedOutputShop((OutputShop)new ZipOutputShop(this, model, out, source), this.getPool());
    }
}

