/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.rof;

import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public class SynchronizedReadOnlyFile
extends DecoratingReadOnlyFile {
    protected final Object lock;

    public SynchronizedReadOnlyFile(@Nullable ReadOnlyFile rof) {
        this(rof, null);
    }

    public SynchronizedReadOnlyFile(@Nullable ReadOnlyFile rof, @CheckForNull Object lock) {
        super(rof);
        this.lock = null != lock ? lock : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFilePointer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.getFilePointer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(long pos) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.seek(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.read(b, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.readFully(b, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.close();
        }
    }
}

