/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api.internal;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.core.api.dto.FileUpload;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportHelper {
    private static final JAXBContext JAXB_CONTEXT;
    private static final Logger logger;

    public RepositoryObject doImport(HttpClient httpClient, String string, String string2) {
        try {
            URL uRL = new URL(string2);
            if (uRL.getProtocol().equals("file")) {
                return this.processFilePath(httpClient, string, uRL.getFile());
            }
            PostMethod postMethod = new PostMethod(string + "/importablePackages/import-url");
            postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(uRL.toString(), "application/xml", "UTF-8"));
            return this.executeAndExtract(httpClient, postMethod);
        }
        catch (MalformedURLException malformedURLException) {
            return this.processFilePath(httpClient, string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private RepositoryObject executeAndExtract(HttpClient httpClient, PostMethod postMethod) {
        try {
            int n = httpClient.executeMethod((HttpMethod)postMethod);
            if (n == 201) {
                return this.extract(postMethod);
            }
            throw new RuntimeException(postMethod.getResponseBodyAsString());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (JAXBException jAXBException) {
            throw new RuntimeException(jAXBException);
        }
    }

    protected RepositoryObject extract(PostMethod postMethod) throws JAXBException, IOException {
        return (RepositoryObject)JAXB_CONTEXT.createUnmarshaller().unmarshal(postMethod.getResponseBodyAsStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepositoryObject processFilePath(HttpClient httpClient, String string, String string2) {
        File file = new File(string2);
        if (file.exists()) {
            RepositoryObject repositoryObject;
            FileUpload fileUpload = new FileUpload();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                fileUpload.setFileData((InputStream)fileInputStream);
                PostMethod postMethod = new PostMethod(string + "/importablePackages/import-uploaded/" + file.getName());
                postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(new Part[]{new FilePart("fileData", file)}, postMethod.getParams()));
                repositoryObject = this.executeAndExtract(httpClient, postMethod);
            }
            catch (IOException iOException) {
                RepositoryObject repositoryObject2;
                try {
                    logger.error("The file '{}' exists, but could not be read for upload; perhaps it's not an archive.", (Object)file.toString());
                    repositoryObject2 = null;
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(fileInputStream);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)fileInputStream);
                return repositoryObject2;
            }
            Closeables.closeQuietly((Closeable)fileInputStream);
            return repositoryObject;
        }
        if (!file.isAbsolute()) {
            PostMethod postMethod = new PostMethod(string + "/importablePackages/import/" + string2);
            return this.executeAndExtract(httpClient, postMethod);
        }
        logger.error("The file '{}' does not exist at the given absolute path", (Object)file.toString());
        return null;
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{RepositoryObject.class});
        }
        catch (JAXBException jAXBException) {
            throw new RuntimeException(jAXBException);
        }
        logger = LoggerFactory.getLogger(ImportHelper.class);
    }
}

