/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.exception.DeployitException;
import com.xebialabs.deployit.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.plugin.api.reflect.ReflectionsHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderScanner;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportedPackage;
import com.xebialabs.deployit.server.api.importer.Importer;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.ListableImporter;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.importer.DefaultImportingContext;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import com.xebialabs.deployit.service.validation.Validator;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ImporterServiceImpl
implements ImporterService {
    private RepositoryService repositoryService;
    private Validator validator;
    private File importablePackageDirectory;
    private List<Importer> importers = Lists.newArrayList();
    private static final Logger logger = LoggerFactory.getLogger(ImporterServiceImpl.class);

    @Autowired
    public ImporterServiceImpl(RepositoryService repositoryService, Validator validator) {
        this.repositoryService = repositoryService;
        this.validator = validator;
    }

    @PostConstruct
    public void initImporters() {
        Set set = ReflectionsHolder.getSubTypesOf(Importer.class);
        logger.debug("Found importers: {}", (Object)set);
        for (Class clazz : set) {
            try {
                if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) continue;
                logger.debug("Importer {} registered.", (Object)clazz);
                this.importers.add((Importer)clazz.newInstance());
            }
            catch (Exception exception) {
                throw new IllegalStateException("Could not instantiate importer: " + clazz, exception);
            }
        }
        Collections.sort(this.importers, new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                return object.getClass().getSimpleName().compareTo(object2.getClass().getSimpleName());
            }
        });
        logger.info("Importers configured in Deployit: {}", this.importers);
    }

    public void setImportablePackageDirectory(File file) {
        this.importablePackageDirectory = file;
    }

    @Override
    public File getImportablePackageDirectory() {
        return this.importablePackageDirectory;
    }

    @Override
    public List<String> listPackages() {
        ArrayList arrayList = Lists.newArrayList();
        for (Importer importer : this.importers) {
            if (!(importer instanceof ListableImporter)) continue;
            arrayList.addAll(((ListableImporter)importer).list(this.importablePackageDirectory));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public String importPackage(ImportSource importSource) {
        try {
            for (Importer importer : this.importers) {
                if (!importer.canHandle(importSource)) continue;
                String string = this.doImport(importSource, importer);
                return string;
            }
            throw new ImporterException("Unable to obtain the package to import from the import source", new Object[0]);
        }
        finally {
            importSource.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doImport(ImportSource importSource, Importer importer) {
        DefaultImportingContext defaultImportingContext = new DefaultImportingContext();
        PackageInfo packageInfo = importer.preparePackage(importSource, (ImportingContext)defaultImportingContext);
        boolean bl = this.isUpgrade(packageInfo);
        this.checkPermission(bl, packageInfo);
        this.checkImported(packageInfo);
        try {
            ImportedPackage importedPackage = importer.importEntities(packageInfo, (ImportingContext)defaultImportingContext);
            this.scanPlaceholders(importedPackage);
            List<ConfigurationItem> list = this.createEntities(importedPackage, bl);
            this.validate(list);
            this.repositoryService.create(list.toArray(new ConfigurationItem[list.size()]));
            String string = importedPackage.getVersion().getId();
            return string;
        }
        finally {
            importer.cleanUp(packageInfo, (ImportingContext)defaultImportingContext);
        }
    }

    private void scanPlaceholders(ImportedPackage importedPackage) {
        if (importedPackage.getVersion() instanceof DeploymentPackage) {
            for (Deployable deployable : importedPackage.getDeployables()) {
                if (!(deployable instanceof SourceArtifact)) continue;
                try {
                    ((SourceArtifact)deployable).initPlaceholders((PlaceholderScanner)new MustachePlaceholderScanner());
                }
                catch (RuntimeException runtimeException) {
                    throw new PlaceholderScanningFailedException(runtimeException, "Unable to scan placeholders in [%s]. See: http://docs.xebialabs.com/faq/#placeholder-scanning", deployable.getId());
                }
            }
        }
    }

    private void checkImported(PackageInfo packageInfo) {
        if (this.repositoryService.exists(IdGenerator.generateId((String)packageInfo.getApplicationId(), (String)packageInfo.getApplicationVersion()))) {
            throw new ImporterException("Already imported version %s of application %s", packageInfo.getApplicationVersion(), packageInfo.getApplicationName());
        }
    }

    private List<ConfigurationItem> createEntities(ImportedPackage importedPackage, boolean bl) {
        ArrayList arrayList = Lists.newArrayList();
        if (!bl) {
            arrayList.add(importedPackage.getApplication());
        }
        arrayList.add(importedPackage.getVersion());
        if (importedPackage.getVersion() instanceof DeploymentPackage) {
            arrayList.addAll(importedPackage.getDeployables());
        }
        return arrayList;
    }

    private void validate(List<ConfigurationItem> list) {
        ArrayList arrayList = Lists.newArrayList();
        for (ConfigurationItem configurationItem : list) {
            arrayList.addAll(this.validator.validate(configurationItem, list));
        }
        if (!arrayList.isEmpty()) {
            throw new ImporterException("Import failed with the following validation errors %s", ((Object)arrayList).toString());
        }
    }

    private boolean isUpgrade(PackageInfo packageInfo) {
        List<ConfigurationItemData> list = this.repositoryService.list(new SearchParameters().setType(Type.valueOf(Application.class)));
        String string = null;
        for (ConfigurationItemData configurationItemData : list) {
            if (!this.subStringAfterLast(configurationItemData.getId(), "/").equals(packageInfo.getApplicationName())) continue;
            Preconditions.checkState((string == null ? 1 : 0) != 0, (String)"Found more than 1 udm.Application with the same name: [%s] and [%s]", (Object[])new Object[]{string, configurationItemData});
            string = configurationItemData.getId();
        }
        if (string != null) {
            packageInfo.setApplicationName(string.substring(Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName().length() + 1));
            return true;
        }
        return false;
    }

    private String subStringAfterLast(String string, String string2) {
        if (string.contains(string2)) {
            return string.substring(string.lastIndexOf(string2) + string2.length());
        }
        return string;
    }

    private void checkPermission(boolean bl, PackageInfo packageInfo) {
        if (bl) {
            this.checkPermission(Permission.IMPORT_UPGRADE, packageInfo.getApplicationId());
        } else {
            this.checkPermission(Permission.IMPORT_INITIAL, packageInfo.getApplicationId());
        }
    }

    void checkPermission(Permission permission, String string) {
        if (!permission.getPermissionHandler().hasPermission(string)) {
            throw PermissionDeniedException.forPermission(permission, string);
        }
    }

    @HttpResponseCodeResult(statusCode=400)
    private class PlaceholderScanningFailedException
    extends DeployitException {
        public PlaceholderScanningFailedException(Exception exception, String string, Object ... objectArray) {
            super(exception, string, objectArray);
        }
    }
}

