/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.comparison;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.springframework.stereotype.Component;

@Component
public class Comparator {
    private static final String PASSWORD_OBFUSCATION = "********";

    public ListMultimap<String, String> compare(ConfigurationItem configurationItem, List<ConfigurationItem> list) {
        ComputingLinkedMap computingLinkedMap = new ComputingLinkedMap(list.size() + 1);
        this.checkCiTypes(configurationItem.getType(), list);
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)configurationItem.getType());
        int n = 0;
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(configurationItem);
        arrayList.addAll(list);
        for (Object object : arrayList) {
            this.writeFields(computingLinkedMap, (ConfigurationItem)object, n);
            this.writeProperties(computingLinkedMap, (ConfigurationItem)object, descriptor, n);
            ++n;
        }
        LinkedListMultimap linkedListMultimap = LinkedListMultimap.create();
        for (String string : computingLinkedMap.keySet()) {
            linkedListMultimap.putAll((Object)string, (Iterable)computingLinkedMap.get(string));
        }
        return linkedListMultimap;
    }

    private void writeProperties(ComputingLinkedMap computingLinkedMap, ConfigurationItem configurationItem, Descriptor descriptor, int n) {
        Collection collection = Collections2.filter((Collection)descriptor.getPropertyDescriptors(), (Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor propertyDescriptor) {
                return !propertyDescriptor.isHidden();
            }
        });
        block5: for (PropertyDescriptor propertyDescriptor : collection) {
            String string = propertyDescriptor.getName();
            Object object = propertyDescriptor.get(configurationItem);
            if (propertyDescriptor.isPassword()) {
                object = PASSWORD_OBFUSCATION;
            }
            switch (propertyDescriptor.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: 
                case CI: {
                    computingLinkedMap.put(string, object != null ? object.toString() : null, n);
                    continue block5;
                }
                case LIST_OF_STRING: 
                case LIST_OF_CI: 
                case SET_OF_STRING: 
                case SET_OF_CI: {
                    this.handleCollectionOfString(computingLinkedMap, string, (Collection)object, n);
                    continue block5;
                }
                case MAP_STRING_STRING: {
                    this.handleMap(computingLinkedMap, string, (Map)object, n);
                    continue block5;
                }
            }
            throw new IllegalStateException("Should not end up here!");
        }
    }

    private void handleMap(ComputingLinkedMap computingLinkedMap, String string, Map<String, String> map, int n) {
        if (map != null) {
            TreeSet<String> treeSet = new TreeSet<String>(map.keySet());
            for (String string2 : treeSet) {
                computingLinkedMap.put(string + ": " + string2, map.get(string2), n);
            }
        }
    }

    private void handleCollectionOfString(ComputingLinkedMap computingLinkedMap, String string, Collection<String> collection, int n) {
        if (collection != null) {
            ArrayList<String> arrayList = new ArrayList<String>(collection);
            Collections.sort(arrayList);
            computingLinkedMap.put(string, Joiner.on((String)",").join(arrayList), n);
        }
    }

    private void writeFields(ComputingLinkedMap computingLinkedMap, ConfigurationItem configurationItem, int n) {
        computingLinkedMap.put("id", configurationItem.getId(), n);
        computingLinkedMap.put("type", configurationItem.getType().toString(), n);
    }

    private void checkCiTypes(Type type, List<ConfigurationItem> list) {
        for (ConfigurationItem configurationItem : list) {
            Checks.checkArgument(configurationItem.getType().equals((Object)type), "Not all configuration items are of type %s", type);
        }
    }

    static class ComputingLinkedMap
    extends LinkedHashMap<String, List<String>> {
        private String[] strings;

        public ComputingLinkedMap(int n) {
            this.strings = new String[n];
            Arrays.fill(this.strings, "");
        }

        @Override
        public List<String> get(Object object) {
            List list = (List)super.get(object);
            if (list == null) {
                list = Lists.newArrayList((Object[])this.strings);
                super.put((String)object, list);
            }
            return list;
        }

        public void put(String string, String string2, int n) {
            Object object = this.get(string);
            object.remove(n);
            object.add(n, string2);
        }
    }
}

