/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.powershell.BasePowerShellDeployed;
import com.xebialabs.deployit.plugin.powershell.PowerShellContainer;

@Metadata(virtual=true)
public class BaseExtensiblePowerShellDeployed<D extends Deployable>
extends BasePowerShellDeployed<D, PowerShellContainer> {
    @Property(hidden=true, required=false, description="PowerShell script invoked to deploy an artifact or a resource on Windows")
    private String createScript;
    @Property(hidden=true, defaultValue="Create", description="The word is used to prefix a step description for the create operation.")
    private String createVerb;
    @Property(hidden=true, defaultValue="60", description="The order in which a create step will be executed.")
    private int createOrder;
    @Property(hidden=true, required=false, description="PowerShell script invoked to upgrade an artifact or a resource on Windows")
    private String modifyScript;
    @Property(hidden=true, defaultValue="Modify", description="The word is used to prefix a step description for the modify operation.")
    private String modifyVerb;
    @Property(hidden=true, defaultValue="60", description="The order in which a modify step will be executed.")
    private int modifyOrder;
    @Property(hidden=true, required=false, description="PowerShell script invoked to undeploy an artifact or a resource on Windows")
    private String destroyScript;
    @Property(hidden=true, defaultValue="Destroy", description="The word is used to prefix a step description for the destroy operation.")
    private String destroyVerb;
    @Property(hidden=true, defaultValue="40", description="The order in which a destroy step will be executed.")
    private int destroyOrder;

    @Create
    public void create(DeploymentPlanningContext deploymentPlanningContext) {
        this.addStep(deploymentPlanningContext, this.createOrder, this.createScript, this.createVerb, true);
    }

    @Modify
    public void modify(DeploymentPlanningContext deploymentPlanningContext, Delta delta) {
        if (!this.addStep(deploymentPlanningContext, this.modifyOrder, this.modifyScript, this.modifyVerb, true)) {
            BaseExtensiblePowerShellDeployed baseExtensiblePowerShellDeployed = (BaseExtensiblePowerShellDeployed)delta.getPrevious();
            baseExtensiblePowerShellDeployed.destroy(deploymentPlanningContext);
            BaseExtensiblePowerShellDeployed baseExtensiblePowerShellDeployed2 = (BaseExtensiblePowerShellDeployed)delta.getDeployed();
            baseExtensiblePowerShellDeployed2.create(deploymentPlanningContext);
        }
    }

    @Destroy
    public void destroy(DeploymentPlanningContext deploymentPlanningContext) {
        this.addStep(deploymentPlanningContext, this.destroyOrder, this.destroyScript, this.destroyVerb, false);
    }
}

