/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.ReflectionUtils;
import com.xebialabs.deployit.plugin.api.reflect.ReflectionsHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

class ValidationRuleConverter {
    public static final String RULE_ELEMENT_NAME = "rule";
    private static final Map<String, Class<? extends Validator<?>>> ruleTypeMap = Maps.newHashMap();

    ValidationRuleConverter() {
    }

    static boolean isRule(Annotation annotation) {
        return annotation.annotationType().isAnnotationPresent(Rule.class);
    }

    static Validator<?> makeRule(Annotation annotation) {
        Class<? extends Annotation> clazz = annotation.annotationType();
        Rule rule = clazz.getAnnotation(Rule.class);
        Validator<?> validator = ValidationRuleConverter.instantiate(rule.clazz());
        for (Method method : clazz.getDeclaredMethods()) {
            Object object = ValidationRuleConverter.getAnnotationValue(annotation, method);
            ReflectionUtils.setField(validator, method.getName(), object);
        }
        return validator;
    }

    static Validator<?> makeRule(Element element, String string) {
        String string2 = element.getAttribute("type");
        Validator<?> validator = ValidationRuleConverter.createRule(element, string2);
        if (validator != null) {
            return validator;
        }
        throw new IllegalArgumentException(String.format("Could not find validation rule type %s defined on property %s", string2, string));
    }

    static Validator<?> makeRule(Element element, Type type) {
        String string = element.getAttribute("type");
        Validator<?> validator = ValidationRuleConverter.createRule(element, string);
        if (validator != null) {
            return validator;
        }
        throw new IllegalArgumentException(String.format("Could not find validation rule type %s defined on type %s", string, type));
    }

    private static Validator<?> createRule(Element element, String string) {
        if (ruleTypeMap.containsKey(string)) {
            Validator<?> validator = ValidationRuleConverter.instantiate(ruleTypeMap.get(string));
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                String string2 = attr.getName();
                if (string2.equals("type")) continue;
                ReflectionUtils.setField(validator, string2, (Object)attr.getValue());
            }
            return validator;
        }
        return null;
    }

    private static Validator<?> instantiate(Class<? extends Validator<?>> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException("Cannot instantiate validation rule " + clazz, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Cannot instantiate validation rule " + clazz, illegalAccessException);
        }
    }

    private static Object getAnnotationValue(Annotation annotation, Method method) {
        try {
            return method.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Could not invoke method.", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw ReflectionUtils.handleInvocationTargetException(invocationTargetException, "Could not convert validation rule.");
        }
    }

    static {
        Set<Class<?>> set = ReflectionsHolder.getClassesAnnotatedWith(Rule.class);
        for (Class<?> clazz : set) {
            Rule rule = clazz.getAnnotation(Rule.class);
            ruleTypeMap.put(rule.type(), rule.clazz());
        }
    }
}

