/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.ImportablePackageProxy;
import com.xebialabs.deployit.core.api.dto.FileUpload;
import com.xebialabs.deployit.core.api.dto.ImportablePackages;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.resteasy.http.tunnel.ResponseFactory;
import com.xebialabs.deployit.core.rest.api.ConfigurationItemDtoWriter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.service.importer.source.FileSource;
import com.xebialabs.deployit.service.importer.source.InputStreamSource;
import com.xebialabs.deployit.service.importer.source.UrlSource;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class ImportablePackageResource
extends AbstractSecuredResource
implements ImportablePackageProxy {
    @Autowired
    private ImporterService importerService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ConfigurationItemDtoWriter dtoWriter;

    public Response list() {
        List list = this.importerService.listPackages();
        return ResponseFactory.ok((Object)new ImportablePackages(list)).build();
    }

    public Response importPackage(String string) {
        if (!this.importerService.getImportablePackageDirectory().exists()) {
            throw new ImporterException(String.format("Directory '%s' to import packages from does not exist", this.importerService.getImportablePackageDirectory().getAbsolutePath()), new Object[0]);
        }
        FileSource fileSource = new FileSource(new File(this.importerService.getImportablePackageDirectory(), string), false);
        return ResponseFactory.created((Object)this.doImport((ImportSource)fileSource)).build();
    }

    public Response importPackageFromUrl(String string) {
        try {
            UrlSource urlSource = new UrlSource(new URL(string));
            return ResponseFactory.created((Object)this.doImport((ImportSource)urlSource)).build();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public Response importUploadedPackage(String string, FileUpload fileUpload) {
        InputStream inputStream = fileUpload.getFileData();
        InputStreamSource inputStreamSource = new InputStreamSource(string, inputStream);
        return ResponseFactory.created((Object)this.doImport((ImportSource)inputStreamSource)).build();
    }

    private RepositoryObject doImport(ImportSource importSource) {
        String string = this.importerService.importPackage(importSource);
        ConfigurationItem configurationItem = this.repositoryService.read(string);
        return this.dtoWriter.write(configurationItem);
    }
}

