/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.authority;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthorityUtils {
    public static final List<GrantedAuthority> NO_AUTHORITIES = Collections.emptyList();

    public static List<GrantedAuthority> commaSeparatedStringToAuthorityList(String authorityString) {
        return AuthorityUtils.createAuthorityList(StringUtils.tokenizeToStringArray((String)authorityString, (String)","));
    }

    public static Set<String> authorityListToSet(Collection<? extends GrantedAuthority> userAuthorities) {
        HashSet<String> set = new HashSet<String>(userAuthorities.size());
        for (GrantedAuthority grantedAuthority : userAuthorities) {
            set.add(grantedAuthority.getAuthority());
        }
        return set;
    }

    public static List<GrantedAuthority> createAuthorityList(String ... roles) {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>(roles.length);
        for (String role : roles) {
            authorities.add(new SimpleGrantedAuthority(role));
        }
        return authorities;
    }
}

