/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.source;

import com.google.common.io.Files;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSource
implements ImportSource {
    private final String location;
    private final boolean tempFile;
    private static final Logger logger = LoggerFactory.getLogger(FileSource.class);

    public FileSource(String string, boolean bl) {
        this.location = string;
        this.tempFile = bl;
    }

    public FileSource(File file, boolean bl) {
        this.location = file.getPath();
        this.tempFile = bl;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isTempFile() {
        return this.tempFile;
    }

    public File getFile() {
        return new File(this.location);
    }

    public void cleanUp() {
        if (this.isTempFile()) {
            try {
                Files.deleteRecursively((File)this.getFile());
            }
            catch (IOException iOException) {
                logger.error("Could not clean up temporary file {}", (Object)this.location);
            }
        }
    }

    public String toString() {
        return "FileSource[" + this.location + "," + this.tempFile + "]";
    }
}

