/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.event;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.event.Event;
import com.xebialabs.deployit.event.EventCallback;
import com.xebialabs.deployit.task.Task;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventBus {
    private static final Map<Class<?>, List<EventCallback<?>>> EVENT_LISTENERS = new HashMap();

    public static synchronized <E extends Event> void registerForEvent(Class<E> clazz, EventCallback<E> eventCallback) {
        ArrayList arrayList = EVENT_LISTENERS.get(clazz);
        if (arrayList == null) {
            arrayList = Lists.newArrayList();
            EVENT_LISTENERS.put(clazz, arrayList);
        }
        arrayList.add(eventCallback);
    }

    public static void deregisterForEvent(Class<Task.TaskStateChangeEvent> clazz, EventCallback<Task.TaskStateChangeEvent> eventCallback) {
        List<EventCallback<?>> list = EVENT_LISTENERS.get(clazz);
        if (list != null) {
            list.remove(eventCallback);
        }
    }

    public static synchronized <E extends Event> void publish(E e) {
        List<EventCallback<?>> list = EVENT_LISTENERS.get(e.getClass());
        if (list == null || list.size() == 0) {
            return;
        }
        for (EventCallback<?> eventCallback : list) {
            eventCallback.receive(e);
        }
    }
}

