/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.setup;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.xebialabs.deployit.DeployitConfig;
import com.xebialabs.deployit.DeployitConfiguration;
import com.xebialabs.deployit.DeployitOptions;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.jcr.JackrabbitRepositoryFactoryBean;
import com.xebialabs.deployit.setup.SetupContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class Setup {
    private static final int DEFAULT_HTTP_PORT = 4516;
    private static final int DEFAULT_HTTPS_PORT = 4517;
    private static final int DEFAULT_MAX_THREADS = 24;
    private static final int DEFAULT_MIN_THREADS = 3;
    private static final String FILE_URL_PREFIX = "file://";
    private static final String DEFAULT_JCR_REPOSITORY_PATH = "repository";
    private static final String DEFAULT_IMPORTABLE_PACKAGES_PATH = "importablePackages";
    private static final String EXITSETUP_KEYWORD = "exitsetup";
    private static final String DEFAULT_HTTP_BIND_ADDRESS = "localhost";
    private static final String DEFAULT_ADMIN_PASSWORD = "admin";

    public static void setup(DeployitOptions deployitOptions) {
        Setup setup = new Setup();
        if (deployitOptions.isReinitialize()) {
            setup.reinitialize(deployitOptions);
        } else {
            setup.run();
        }
    }

    private void reinitialize(DeployitOptions deployitOptions) {
        if (!deployitOptions.isForce()) {
            System.out.println("The -reinitialize will only work with a default repository setup; Not when you've configured Deployit to integrate with a database.");
            System.out.println("Are you sure you want to continue (yes or no)?");
            if (!this.getBooleanResponse(false)) {
                return;
            }
        }
        SetupContext setupContext = new SetupContext();
        this.useDefaultValues(setupContext);
        DeployitConfiguration.writeConfiguration((DeployitConfig)setupContext);
        DeployitConfiguration.load();
        this.initializeJcrRepository(setupContext);
        this.deleteTaskRecoveryFile();
    }

    private void run() {
        System.out.println("\nWelcome to the Deployit setup.");
        System.out.println("You can always exit by typing 'exitsetup'.");
        System.out.println("To re-run this setup and make changes to the Deployit server configuration you can run server.cmd -setup on Windows or server.sh -setup on Unix.");
        SetupContext setupContext = new SetupContext();
        boolean bl = false;
        if (DeployitConfiguration.exists() && this.askDoYouWantToEditTheExistingConfiguration(setupContext)) {
            DeployitConfiguration.readIntoConfiguration((DeployitConfig)setupContext);
            bl = true;
        }
        if (this.askDoYouWantToUseTheSimpleSetup()) {
            if (!bl) {
                this.useDefaultValues(setupContext);
            } else {
                this.upgradeConfigurationWithDefaultValues(setupContext);
            }
            this.askToInitializeJcr(setupContext);
        } else {
            if (this.askToEnableSsl(setupContext)) {
                if (this.askToGenerateKeys(setupContext)) {
                    this.setDefaultKeyStoreSettings(setupContext);
                } else {
                    this.askKeyStoreSettings(setupContext);
                }
            }
            this.askHttpBindAddressForJetty(setupContext);
            this.askHttpPortForJetty(setupContext);
            this.askWebContextRoot(setupContext);
            this.askMinumAmountOfThreads(setupContext);
            this.askMaximumAmountOfThreads(setupContext);
            this.askJcrRepositoryPath(setupContext);
            this.askToInitializeJcr(setupContext);
            this.askImprotablePackagesPath(setupContext);
        }
        if (this.reviewAndConfirm(setupContext)) {
            System.out.println("Saving to " + DeployitConfiguration.DEFAULT_CONFIGURATION_FILE);
            DeployitConfiguration.writeConfiguration((DeployitConfig)setupContext);
            System.out.println("Configuration saved.");
            if (setupContext.isGenerateKeyStore()) {
                this.generateKeyStore(setupContext);
            }
            DeployitConfiguration.load();
            if (setupContext.isInitializeJcrRepository()) {
                this.initializeJcrRepository(setupContext);
            }
            System.out.println("You can now start your Deployit server by executing the command server.cmd on Windows or server.sh on Unix.");
            System.out.println("Note: If your Deployit server is running please restart it.");
            System.out.println("Finished setup.");
        } else {
            System.out.println("Aborting setup.");
        }
    }

    private void askWebContextRoot(SetupContext setupContext) {
        this.printEmptyLine();
        System.out.println("Enter the web context root where Deployit will run");
        String string = this.getStringResponse("/");
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        setupContext.setWebContextRoot(string);
    }

    private void upgradeConfigurationWithDefaultValues(SetupContext setupContext) {
        if (setupContext.getMinThreads() == 0) {
            setupContext.setMinThreads(3);
        }
        if (setupContext.getMaxThreads() == 0) {
            setupContext.setMaxThreads(24);
        }
        if (setupContext.getImportablePackagesPath() == null) {
            setupContext.setImportablePackagesPath(DEFAULT_IMPORTABLE_PACKAGES_PATH);
        }
    }

    private void askMinumAmountOfThreads(SetupContext setupContext) {
        this.printEmptyLine();
        System.out.println("Enter the minimum number of threads the HTTP server should use (recommended: 3 per client, so 3 for single user usage)");
        int n = 3;
        int n2 = setupContext.getMinThreads() == 0 ? n : setupContext.getMinThreads();
        setupContext.setMinThreads(this.getValidIntegerResponse(n2));
    }

    private void askMaximumAmountOfThreads(SetupContext setupContext) {
        this.printEmptyLine();
        System.out.println("Enter the maximum number of threads the HTTP server should use (recommended :3 per client, so 24 for 8 concurrent users)");
        int n = 24;
        int n2 = setupContext.getMaxThreads() == 0 ? n : setupContext.getMaxThreads();
        setupContext.setMaxThreads(this.getValidIntegerResponse(n2));
    }

    private void useDefaultValues(SetupContext setupContext) {
        setupContext.setJcrRepositoryPath(DEFAULT_JCR_REPOSITORY_PATH);
        setupContext.setHttpBindAddress(DEFAULT_HTTP_BIND_ADDRESS);
        setupContext.setHttpPort(4516);
        setupContext.setImportablePackagesPath(DEFAULT_IMPORTABLE_PACKAGES_PATH);
        setupContext.setMinThreads(3);
        setupContext.setMaxThreads(24);
        setupContext.setAdminPassword(DEFAULT_ADMIN_PASSWORD);
    }

    private boolean askDoYouWantToUseTheSimpleSetup() {
        this.printEmptyLine();
        System.out.println("Do you want to use the simple setup?");
        System.out.println("Default values are used for all properties. To make changes to the default properties, please answer no.");
        System.out.println("Options are yes or no.");
        return this.getBooleanResponse(true);
    }

    private boolean askToEnableSsl(SetupContext setupContext) {
        this.printEmptyLine();
        System.out.println("Would you like to enable SSL?");
        System.out.println("Options are yes or no.");
        boolean bl = setupContext.isNewConfiguration() || setupContext.isSsl();
        setupContext.setSsl(this.getBooleanResponse(bl));
        return setupContext.isSsl();
    }

    private boolean askToGenerateKeys(SetupContext setupContext) {
        this.printEmptyLine();
        System.out.println("Would you like Deployit to generate a keystore with a self-signed certificate for you?");
        System.out.println("N.B.: Self-signed certificates do not work correctly with some versions of the Flash Player and some browsers!");
        System.out.println("Options are yes or no.");
        boolean bl = setupContext.isNewConfiguration() || setupContext.isGenerateKeyStore();
        setupContext.setGenerateKeyStore(this.getBooleanResponse(bl));
        return setupContext.isGenerateKeyStore();
    }

    private void setDefaultKeyStoreSettings(SetupContext setupContext) {
        setupContext.setKeyStorePath("conf/keystore.jks");
        setupContext.setKeyStorePassword("storesecret");
        setupContext.setKeyStoreKeyPassword("keysecret");
    }

    private void askKeyStoreSettings(SetupContext setupContext) {
        this.printEmptyLine();
        System.out.println("What is the path to the keystore?");
        String string = setupContext.isNewConfiguration() ? "" : setupContext.getKeyStorePath();
        setupContext.setKeyStorePath(this.getStringResponse(string));
        this.printEmptyLine();
        System.out.println("What is the password to the keystore?");
        String string2 = setupContext.isNewConfiguration() ? "" : setupContext.getKeyStorePassword();
        setupContext.setKeyStorePassword(this.getStringResponse(string2));
        this.printEmptyLine();
        System.out.println("What is the password to the key in the keystore?");
        String string3 = setupContext.isNewConfiguration() ? "" : setupContext.getKeyStoreKeyPassword();
        setupContext.setKeyStoreKeyPassword(this.getStringResponse(string3));
    }

    private void askHttpBindAddressForJetty(SetupContext setupContext) {
        this.printEmptyLine();
        System.out.println("What http bind address would you like the server to listen on?");
        String string = Strings.nullToEmpty((String)setupContext.getHttpBindAddress()).isEmpty() ? DEFAULT_HTTP_BIND_ADDRESS : setupContext.getHttpBindAddress();
        setupContext.setHttpBindAddress(this.getStringResponse(string));
    }

    private void askHttpPortForJetty(SetupContext setupContext) {
        this.printEmptyLine();
        System.out.println("What http port number would you like the server to listen on?");
        int n = setupContext.isSsl() ? 4517 : 4516;
        int n2 = setupContext.getHttpPort() == 0 ? n : setupContext.getHttpPort();
        setupContext.setHttpPort(this.getValidIntegerResponse(n2));
    }

    private void askImprotablePackagesPath(SetupContext setupContext) {
        this.printEmptyLine();
        System.out.println("Where would you like Deployit to import packages from?");
        String string = setupContext.getImportablePackagesPath() == null ? DEFAULT_IMPORTABLE_PACKAGES_PATH : setupContext.getImportablePackagesPath();
        setupContext.setImportablePackagesPath(this.getValidNotEmptyStringResponse(string));
    }

    private boolean askDoYouWantToEditTheExistingConfiguration(SetupContext setupContext) {
        this.printEmptyLine();
        System.out.println("An existing configuration was found. Do you want to edit it?");
        System.out.println("Options are yes or no. (selecting no will create an empty configuration)");
        boolean bl = this.getBooleanResponse(true);
        if (bl) {
            System.out.println("Editing the exisiting configuration.");
        } else {
            System.out.println("Starting configuration from scratch.");
        }
        return bl;
    }

    private void askJcrRepositoryPath(SetupContext setupContext) {
        this.printEmptyLine();
        System.out.println("Where would you like Deployit to store the JCR repository?");
        String string = setupContext.getJcrRepositoryPath() == null ? DEFAULT_JCR_REPOSITORY_PATH : setupContext.getJcrRepositoryPath();
        String string2 = this.getValidNotEmptyStringResponse(string);
        setupContext.setJcrRepositoryPath(this.convertAbsolutePathToFileUrlIfNeeded(string2));
    }

    private String convertAbsolutePathToFileUrlIfNeeded(String string) {
        if (string.startsWith("/") || string.length() >= 3 && string.charAt(1) == ':' && string.charAt(2) == '\\') {
            return FILE_URL_PREFIX + string;
        }
        return string;
    }

    private boolean askToInitializeJcr(SetupContext setupContext) {
        this.printEmptyLine();
        System.out.println("Do you want Deployit to initialize the JCR repository?");
        System.out.println("Options are yes or no.");
        if (setupContext.isNewConfiguration()) {
            setupContext.setInitializeJcrRepository(this.getBooleanResponse(true));
        } else {
            setupContext.setInitializeJcrRepository(this.getBooleanResponse(false));
        }
        if (setupContext.isInitializeJcrRepository()) {
            System.out.println("Deployit will initialize the JCR repository.");
        } else {
            System.out.println("Deployit will NOT initialize the JCR repository.");
        }
        return setupContext.isInitializeJcrRepository();
    }

    private boolean reviewAndConfirm(SetupContext setupContext) {
        this.printEmptyLine();
        System.out.println("Do you agree with the following settings for Deployit and would you like to save them?");
        System.out.println("Changes will be saved in deployit.conf");
        System.out.println("\tSSL will be " + (setupContext.isSsl() ? "enabled" : "disabled"));
        if (setupContext.isSsl()) {
            if (setupContext.isGenerateKeyStore()) {
                System.out.println("\tKeystore will be generated");
            } else {
                System.out.println("\tKeystore path is " + setupContext.getKeyStorePath());
                System.out.println("\tKeystore password is " + setupContext.getKeyStorePassword());
                System.out.println("\tKeystore key password is " + setupContext.getKeyStoreKeyPassword());
            }
        }
        System.out.println("\tHTTP bind address is " + setupContext.getHttpBindAddress());
        System.out.println("\tHTTP port is " + setupContext.getHttpPort());
        System.out.println("\tContext root is " + setupContext.getWebContextRoot());
        System.out.println("\tHTTP server will use a minimum of " + setupContext.getMinThreads() + " and a maximum of " + setupContext.getMaxThreads() + " threads");
        try {
            System.out.println("\tJCR repository home is at " + this.resolveRepositoryHome(setupContext).getFile().getAbsolutePath());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (setupContext.isInitializeJcrRepository()) {
            System.out.println("\tJCR repository will be initialized.");
            System.out.println("\tTask recovery file will be deleted");
        }
        System.out.println("\tApplication import location is " + setupContext.getImportablePackagesPath());
        return this.getBooleanResponse(true);
    }

    private void generateKeyStore(SetupContext setupContext) {
        String string = "RSA";
        String string2 = "jetty";
        String string3 = "CN=localhost,O=Deployit,C=NL";
        try {
            int n;
            File file = new File(setupContext.getKeyStorePath());
            if (file.exists()) {
                System.out.println("Existing keystore " + setupContext.getKeyStorePath() + " deleted.");
                file.delete();
            }
            System.out.println("Generating keystore...");
            String[] stringArray = new String[]{"keytool", "-genkey", "-keyalg", string, "-keystore", setupContext.getKeyStorePath(), "-storepass", setupContext.getKeyStorePassword(), "-alias", string2, "-keypass", setupContext.getKeyStoreKeyPassword(), "-validity", "366", "-dname", string3};
            Process process = Runtime.getRuntime().exec(stringArray);
            Thread thread = new Thread(new InputStreamToOutputStream(process.getInputStream(), System.out));
            thread.start();
            Thread thread2 = new Thread(new InputStreamToOutputStream(process.getErrorStream(), System.err));
            thread2.start();
            try {
                n = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException.toString());
            }
            if (n != 0) {
                throw new IOException("keytool exited with status code " + n);
            }
            System.out.println("Keystore generated.");
        }
        catch (IOException iOException) {
            System.err.println("WARNING: Could not generate keystore " + setupContext.getKeyStorePath() + ": " + iOException.toString());
        }
    }

    private void initializeJcrRepository(SetupContext setupContext) {
        Resource resource = this.resolveRepositoryHome(setupContext);
        this.cleanUpAndReinitializeRepositoryHome(resource);
        JackrabbitRepositoryFactoryBean jackrabbitRepositoryFactoryBean = new JackrabbitRepositoryFactoryBean();
        jackrabbitRepositoryFactoryBean.setConfiguration((Resource)new ClassPathResource("jackrabbit-repository.xml"));
        jackrabbitRepositoryFactoryBean.setHomeDir(resource);
        jackrabbitRepositoryFactoryBean.setAutoInitialize(true);
        try {
            jackrabbitRepositoryFactoryBean.afterPropertiesSet();
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot initialize JCR repository", exception);
        }
        jackrabbitRepositoryFactoryBean.destroy();
        System.out.println("JCR repository initialized.");
        this.deleteTaskRecoveryFile();
    }

    private Resource resolveRepositoryHome(SetupContext setupContext) {
        FileSystemResource fileSystemResource;
        if (setupContext.getJcrRepositoryPath().startsWith(FILE_URL_PREFIX)) {
            try {
                fileSystemResource = new UrlResource(setupContext.getJcrRepositoryPath());
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException("JCR Repository path is a malformed url. " + setupContext.getJcrRepositoryPath());
            }
        } else {
            fileSystemResource = new FileSystemResource(setupContext.getJcrRepositoryPath());
        }
        return fileSystemResource;
    }

    private void cleanUpAndReinitializeRepositoryHome(Resource resource) {
        File file = null;
        try {
            file = resource.getFile();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Problem resolving absolute path to JCR repository at " + resource.getFilename(), (Throwable)iOException);
        }
        if (file.exists()) {
            System.out.println("Deleting JCR repository at " + file);
            try {
                Files.deleteRecursively((File)file);
            }
            catch (IOException iOException) {
                throw new RuntimeIOException("Cannot delete JCR repository at " + file, (Throwable)iOException);
            }
        }
        System.out.println("Creating JCR repository at " + file);
        boolean bl = file.mkdirs();
        if (!bl) {
            throw new RuntimeIOException("Unknown error occured while creating JCR repository at " + resource);
        }
    }

    private void deleteTaskRecoveryFile() {
        File file = new File("recovery.dat");
        if (file.exists()) {
            if (file.delete()) {
                System.out.println("Task recovery file deleted");
            } else {
                System.err.println("Couldn't delete the task recovery file");
            }
        }
    }

    private void printEmptyLine() {
        System.out.println("");
    }

    private String read() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String string = bufferedReader.readLine();
            if (string != null) {
                String string2 = string.trim();
                if (EXITSETUP_KEYWORD.equals(string2)) {
                    System.out.println("Exiting setup.");
                    System.exit(1);
                }
                return string2;
            }
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private boolean getBooleanResponse(boolean bl) {
        String string = this.determinePrompt(bl ? "yes" : "no");
        while (true) {
            System.out.print(string);
            String string2 = this.read();
            if ("".equals(string2)) {
                return bl;
            }
            if ("yes".equalsIgnoreCase(string2)) {
                return true;
            }
            if ("no".equalsIgnoreCase(string2)) {
                return false;
            }
            System.out.println("Illegal value specified, type yes or no.");
        }
    }

    private String getValidNotEmptyStringResponse(String string) {
        String string2 = this.determinePrompt(string);
        while (true) {
            System.out.print(string2);
            String string3 = this.read();
            if ("".equals(string3) && string != null) {
                string3 = string;
            }
            if (!"".equals(string3) && string3 != null) {
                return string3;
            }
            System.out.println("Value cannot be empty.");
        }
    }

    private String getStringResponse(String string) {
        String string2;
        String string3 = this.determinePrompt(string);
        do {
            System.out.print(string3);
            string2 = this.read();
            if (!"".equals(string2)) continue;
            string2 = string;
        } while (string2 == null);
        return string2;
    }

    private int getValidIntegerResponse(int n) {
        String string = Integer.toString(n);
        String string2 = this.determinePrompt(string);
        while (true) {
            System.out.print(string2);
            String string3 = this.read();
            if ("".equals(string3)) {
                string3 = string;
            }
            try {
                int n2 = Integer.parseInt(string3);
                if (n2 > 0) {
                    return n2;
                }
                System.out.println("Illegal value specified. Number must be larger then 0.");
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Illegal value specified. Must be a number.");
                continue;
            }
            break;
        }
    }

    private String determinePrompt(String string) {
        String string2 = string != null ? "[" + string + "]: " : ": ";
        return string2;
    }

    private static class InputStreamToOutputStream
    implements Runnable {
        private InputStream in;
        private OutputStream out;

        public InputStreamToOutputStream(InputStream inputStream, OutputStream outputStream) {
            this.in = inputStream;
            this.out = outputStream;
        }

        @Override
        public void run() {
            try {
                ByteStreams.copy((InputStream)this.in, (OutputStream)this.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

