/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.ObservationManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AccessControlUtils;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAccessControlProvider
implements AccessControlProvider,
AccessControlUtils,
AccessControlConstants {
    public static final String PARAM_OMIT_DEFAULT_PERMISSIONS = "omit-default-permission";
    protected SessionImpl session;
    protected ObservationManager observationMgr;
    protected NamePathResolver resolver;
    protected int privAll;
    protected int privRead;
    private boolean initialized;

    protected AbstractAccessControlProvider() {
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized or already closed.");
        }
    }

    protected CompiledPermissions getAdminPermissions() {
        return new CompiledPermissions(){

            public void close() {
            }

            public boolean grants(Path absPath, int permissions) {
                return true;
            }

            public int getPrivileges(Path absPath) {
                return AbstractAccessControlProvider.this.privAll;
            }

            public boolean canReadAll() {
                return true;
            }

            public boolean canRead(Path itemPath, ItemId itemId) throws RepositoryException {
                return true;
            }
        };
    }

    protected CompiledPermissions getReadOnlyPermissions() {
        return new CompiledPermissions(){

            public void close() {
            }

            public boolean grants(Path absPath, int permissions) throws RepositoryException {
                if (AbstractAccessControlProvider.this.isAcItem(absPath)) {
                    return false;
                }
                return permissions == 1;
            }

            public int getPrivileges(Path absPath) throws RepositoryException {
                if (AbstractAccessControlProvider.this.isAcItem(absPath)) {
                    return 0;
                }
                return AbstractAccessControlProvider.this.privRead;
            }

            public boolean canReadAll() {
                return false;
            }

            public boolean canRead(Path itemPath, ItemId itemId) throws RepositoryException {
                if (itemPath != null) {
                    return !AbstractAccessControlProvider.this.isAcItem(itemPath);
                }
                return !AbstractAccessControlProvider.this.isAcItem(AbstractAccessControlProvider.this.session.getItemManager().getItem(itemId));
            }
        };
    }

    @Override
    public boolean isAcItem(Path absPath) throws RepositoryException {
        Path.Element[] elems = absPath.getElements();
        if (elems.length > 1) {
            int index = elems.length - 1;
            for (int j = 1; index >= 0 && j <= 3; --index, ++j) {
                if (!N_POLICY.equals(elems[index].getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAcItem(ItemImpl item) throws RepositoryException {
        NodeImpl n = item.isNode() ? (NodeImpl)item : (NodeImpl)item.getParent();
        Name ntName = ((NodeTypeImpl)n.getPrimaryNodeType()).getQName();
        return ntName.equals(NT_REP_ACL) || ntName.equals(NT_REP_GRANT_ACE) || ntName.equals(NT_REP_DENY_ACE);
    }

    @Override
    public boolean isAdminOrSystem(Set<Principal> principals) {
        for (Principal p : principals) {
            if (!(p instanceof AdminPrincipal) && !(p instanceof SystemPrincipal)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReadOnly(Set<Principal> principals) {
        return false;
    }

    @Override
    public void init(Session systemSession, Map configuration) throws RepositoryException {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        if (!(systemSession instanceof SessionImpl)) {
            throw new RepositoryException("SessionImpl (system session) expected.");
        }
        this.session = (SessionImpl)systemSession;
        this.observationMgr = systemSession.getWorkspace().getObservationManager();
        this.resolver = (NamePathResolver)systemSession;
        this.privAll = PrivilegeRegistry.getBits(new Privilege[]{this.session.getAccessControlManager().privilegeFromName("{http://www.jcp.org/jcr/1.0}all")});
        this.privRead = PrivilegeRegistry.getBits(new Privilege[]{this.session.getAccessControlManager().privilegeFromName("{http://www.jcp.org/jcr/1.0}read")});
        this.initialized = true;
    }

    @Override
    public void close() {
        this.checkInitialized();
        this.initialized = false;
    }

    @Override
    public boolean isLive() {
        return this.initialized && this.session.isLive();
    }
}

