/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.DeploymentProxy;
import com.xebialabs.deployit.core.api.dto.Deployment;
import com.xebialabs.deployit.core.api.dto.FullTaskInfo;
import java.util.List;

@CliObject(name="deployment")
@ClassHelp(description="Perform tasks related to setting up deployments")
public class DeploymentClient
extends DocumentedObject {
    private final DeploymentProxy deploymentProxy;

    public DeploymentClient() {
        this.deploymentProxy = null;
    }

    public DeploymentClient(Proxies proxies) {
        this.deploymentProxy = proxies.getDeployment();
    }

    @MethodHelp(description="Prepare an initial deployment of a version to an environment", parameters={@ParameterHelp(name="version", description="The source deployment package that is to be deployed"), @ParameterHelp(name="environment", description="The environment that you want to deploy to")}, returns="A deployment that can be edited further")
    public Deployment prepareInitial(String string, String string2) {
        return (Deployment)ResponseExtractor.getEntity(this.deploymentProxy.prepareInitial(string, string2));
    }

    @MethodHelp(description="Prepare an upgrade deployment of an existing deployed application", parameters={@ParameterHelp(name="version", description="The source deployment package that is to be deployed"), @ParameterHelp(name="deployedApplication", description="The deployed application that should be upgraded")}, returns="A deployment that can be edited further, with the deployed configuration items upgraded")
    public Deployment prepareUpgrade(String string, String string2) {
        return (Deployment)ResponseExtractor.getEntity(this.deploymentProxy.prepareUpgrade(string, string2));
    }

    @MethodHelp(description="Generate all default deployed configuration items for deployment", parameters={@ParameterHelp(name="deployment", description="The deployment to generate all the deployed configuration items for")}, returns="The deployment updated with all the generated deployed configuration items")
    public Deployment generateAllDeployeds(Deployment deployment) {
        return (Deployment)ResponseExtractor.getEntity(this.deploymentProxy.generateAllDeployeds(deployment));
    }

    @MethodHelp(description="Generate default deployed configuration items for only the passed in deployables.", parameters={@ParameterHelp(name="deployables", description="The list of a deployable ids"), @ParameterHelp(name="deployment", description="The deployment to generate the deployed configuration items for")}, returns="The deployment updated with all the generated deployed configuration items")
    public Deployment generateSelectedDeployeds(List<String> list, Deployment deployment) {
        return (Deployment)ResponseExtractor.getEntity(this.deploymentProxy.generateSelectedDeployeds(list, deployment));
    }

    @MethodHelp(description="Generate default deployed configuration item for the deployable to the container", parameters={@ParameterHelp(name="deployable", description="The deployable to deploy"), @ParameterHelp(name="container", description="The container to deploy to"), @ParameterHelp(name="deployment", description="The deployment to generate the deployed configuration item for")}, returns="The deployment updated with the generated deployed configuration item")
    public Deployment generateSingleDeployed(String string, String string2, Deployment deployment) {
        return (Deployment)ResponseExtractor.getEntity(this.deploymentProxy.generateSingleDeployed(string, string2, null, deployment));
    }

    @MethodHelp(description="Generate default deployed configuration item for the deployable to the container of the specified type", parameters={@ParameterHelp(name="deployable", description="The deployable to deploy"), @ParameterHelp(name="container", description="The container to deploy to"), @ParameterHelp(name="type", description="The type of the deployed configuration item to generate"), @ParameterHelp(name="deployment", description="The deployment to generate the deployed configuration item for")}, returns="The deployment updated with the generated deployed configuration item")
    public Deployment generateSingleDeployed(String string, String string2, String string3, Deployment deployment) {
        return (Deployment)ResponseExtractor.getEntity(this.deploymentProxy.generateSingleDeployed(string, string2, string3, deployment));
    }

    @MethodHelp(description="Validate the deployment that you want to perform", parameters={@ParameterHelp(name="deployment", description="The deployment to validate")}, returns="The validated deployment with added validation messages")
    public Deployment validate(Deployment deployment) {
        return (Deployment)ResponseExtractor.getEntity(this.deploymentProxy.validate(deployment));
    }

    @MethodHelp(description="Prepare the deployment, readying it for execution", parameters={@ParameterHelp(name="deployment", description="The deployment to perform")}, returns="The task information needed to start the deployment")
    public FullTaskInfo deploy(Deployment deployment) {
        return (FullTaskInfo)ResponseExtractor.getEntity(this.deploymentProxy.deploy(deployment));
    }

    @MethodHelp(description="Undeploy the deployed application", parameters={@ParameterHelp(name="deployedApplication", description="The deployed application to undeploy")}, returns="The task information needed to start the undeployment")
    public FullTaskInfo undeploy(String string) {
        return (FullTaskInfo)ResponseExtractor.getEntity(this.deploymentProxy.undeploy(string));
    }
}

