/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class ReportUtils {
    static final PeriodFormatter HH_MM_SS = new PeriodFormatterBuilder().minimumPrintedDigits(2).printZeroAlways().appendHours().appendSeparator(":").appendMinutes().appendSeparator(":").appendSeconds().toFormatter();
    static final PeriodFormatter MM_SS = new PeriodFormatterBuilder().printZeroAlways().minimumPrintedDigits(1).appendMinutes().appendSeparator(":").appendSeconds().toFormatter();

    static final String formatToMinsAndSecs(long millis) {
        Period period = new Duration(millis).toPeriod();
        return MM_SS.print((ReadablePeriod)period);
    }

    static final String formatToHoursMinsSecs(long millis) {
        Period period = new Duration(millis).toPeriod();
        return HH_MM_SS.print((ReadablePeriod)period);
    }
}

