/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.replacement;

import com.samskivert.mustache.MustacheException;
import com.xebialabs.deployit.service.deployment.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholders;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class MustachePlaceholderReplacer {
    public static final String IGNORE_PLACEHOLDER = "<ignore>";
    public static final String EMPTY_PLACEHOLDER = "<empty>";
    private final Map<String, ? extends Object> values;
    private final boolean interpretSpecialValues;

    public MustachePlaceholderReplacer(Map<String, ? extends Object> values) {
        this(values, true);
    }

    public MustachePlaceholderReplacer(Map<String, ? extends Object> values, boolean interpretSpecialValues) {
        this.interpretSpecialValues = interpretSpecialValues;
        this.values = new ReplacerMap(values);
    }

    public String replace(String replaceable) throws DictionaryValueException {
        try {
            return MustachePlaceholders.newMustacheCompiler().compile(replaceable).execute(this.values);
        }
        catch (MustacheException me) {
            throw new DictionaryValueException(me, "Could not replace dictionary keys in %s", replaceable);
        }
    }

    public void replace(Reader in, Writer out) {
        MustachePlaceholders.newMustacheCompiler().compile(in).execute(this.values, out);
    }

    private class ReplacerMap
    extends HashMap<String, Object> {
        public ReplacerMap(Map<? extends String, ? extends Object> map) {
            super(map);
        }

        @Override
        public Object get(Object o) {
            Object s = super.get(o);
            if (MustachePlaceholderReplacer.this.interpretSpecialValues) {
                if (MustachePlaceholderReplacer.IGNORE_PLACEHOLDER.equals(s)) {
                    return "{{" + o + "}}";
                }
                if (MustachePlaceholderReplacer.EMPTY_PLACEHOLDER.equals(s)) {
                    return "";
                }
            }
            return s;
        }
    }
}

