/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.file.deployed;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedArtifact;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.deployed.CopiedArtifact;
import com.xebialabs.deployit.plugin.overthere.Host;

@Metadata(virtual=true, description="Abstract deployed that can target any DeployableArtifact to a Host.")
public class DeployedArtifactOnHost<D extends DeployableArtifact>
extends BaseDeployedArtifact<D, Host> {
    @Property(description="Path to which artifact must be copied to on the host.")
    private String targetPath;
    @Property(defaultValue="true", description="Is the targetPath shared by others on the host. When true, the targetPath is not deleted during undeployment; only the artifacts copied to it.", required=false)
    private boolean targetPathShared;
    @Property(defaultValue="false", description="Create the targetPath on the host if it does not exist.", required=false)
    private boolean createTargetPath;
    @Property(required=false, description="Name of the artifact on the host.")
    private String targetFileName;

    private CopiedArtifact<D> createDelegate() {
        CopiedArtifact delegate = new CopiedArtifact();
        delegate.setSyntheticProperties(this.getSyntheticProperties());
        delegate.setPlaceholders(this.getPlaceholders());
        delegate.setFile(this.getFile());
        delegate.setId(this.getId());
        Container container = new Container();
        container.setHost((Host)this.getContainer());
        container.setId(((Host)this.getContainer()).getId());
        delegate.setContainer((com.xebialabs.deployit.plugin.api.udm.Container)container);
        delegate.setDeployable(this.getDeployable());
        delegate.setCreateOrder(60);
        delegate.setDestroyOrder(40);
        delegate.setCreateTargetDirectory(this.isCreateTargetPath());
        delegate.setTargetFile(this.getTargetFileName());
        delegate.setTargetDirectory(this.getTargetPath());
        delegate.setTargetDirectoryShared(this.isTargetPathShared());
        delegate.setUseDescriptionGeneratedByStep(true);
        return delegate;
    }

    @Create
    public void executeCreate(DeploymentPlanningContext ctx) {
        CopiedArtifact<D> delegate = this.createDelegate();
        delegate.executeCreate(ctx);
    }

    @Modify
    public void executeModify(DeploymentPlanningContext ctx, Delta d) {
        DeployedArtifactOnHost previous = (DeployedArtifactOnHost)d.getPrevious();
        previous.executeDestroy(ctx);
        this.executeCreate(ctx);
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext ctx) {
        CopiedArtifact<D> delegate = this.createDelegate();
        delegate.executeDestroy(ctx);
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public boolean isTargetPathShared() {
        return this.targetPathShared;
    }

    public void setTargetPathShared(boolean targetPathShared) {
        this.targetPathShared = targetPathShared;
    }

    public boolean isCreateTargetPath() {
        return this.createTargetPath;
    }

    public void setCreateTargetPath(boolean createTargetPath) {
        this.createTargetPath = createTargetPath;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }
}

