/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.ssh.SshConnection;
import com.xebialabs.overthere.ssh.SshSftpFile;
import java.io.IOException;
import net.schmizz.sshj.sftp.SFTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SshSftpConnection
extends SshConnection {
    private SFTPClient sharedSftpClient;
    private Logger logger = LoggerFactory.getLogger(SshSftpConnection.class);

    public SshSftpConnection(String type, ConnectionOptions options) {
        super(type, options);
    }

    @Override
    protected void connect() {
        super.connect();
        this.logger.debug("Opening SFTP client to {}", (Object)this);
        try {
            this.sharedSftpClient = this.getSshClient().newSFTPClient();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot make SFTP connection to " + this, e);
        }
    }

    @Override
    public void doClose() {
        Preconditions.checkState((this.sharedSftpClient != null ? 1 : 0) != 0, (Object)"Not connected to SFTP");
        this.logger.debug("Closing SFTP client to {}", (Object)this);
        try {
            this.sharedSftpClient.close();
        }
        catch (IOException e) {
            this.logger.error("Couldn't close the SFTP client", (Throwable)e);
        }
        this.sharedSftpClient = null;
        super.doClose();
    }

    protected SFTPClient getSharedSftpClient() {
        return this.sharedSftpClient;
    }

    @Override
    public OverthereFile getFile(String hostPath, boolean isTempFile) throws RuntimeIOException {
        return new SshSftpFile(this, hostPath);
    }

    protected abstract String pathToSftpPath(String var1);
}

