/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.ssh.SshFile;
import com.xebialabs.overthere.ssh.SshScpConnection;
import com.xebialabs.overthere.util.CapturingOverthereProcessOutputHandler;
import com.xebialabs.overthere.util.LoggingOverthereProcessOutputHandler;
import com.xebialabs.overthere.util.MultipleOverthereProcessOutputHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.schmizz.sshj.xfer.LocalFileFilter;
import net.schmizz.sshj.xfer.LocalSourceFile;
import net.schmizz.sshj.xfer.scp.SCPUploadClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshScpFile
extends SshFile<SshScpConnection> {
    private Logger logger = LoggerFactory.getLogger(SshScpFile.class);

    public SshScpFile(SshScpConnection connection, String remotePath) {
        super(connection, remotePath);
    }

    @Override
    public boolean exists() {
        return this.getFileInfo().exists;
    }

    @Override
    public boolean canRead() {
        return this.getFileInfo().canRead;
    }

    @Override
    public boolean canWrite() {
        return this.getFileInfo().canWrite;
    }

    @Override
    public boolean canExecute() {
        return this.getFileInfo().canExecute;
    }

    @Override
    public boolean isFile() {
        return this.getFileInfo().isFile;
    }

    @Override
    public boolean isDirectory() {
        return this.getFileInfo().isDirectory;
    }

    @Override
    public long lastModified() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long length() {
        return this.getFileInfo().length;
    }

    public LsResults getFileInfo() throws RuntimeIOException {
        LsResults results = new LsResults();
        CapturingOverthereProcessOutputHandler capturedOutput = CapturingOverthereProcessOutputHandler.capturingHandler();
        int errno = this.executeCommand(capturedOutput, CmdLine.build("ls", "-ld", this.getPath()));
        if (errno == 0) {
            results.exists = true;
            if (capturedOutput.getOutputLines().size() > 0) {
                StringTokenizer outputTokens;
                String outputLine = capturedOutput.getOutputLines().get(capturedOutput.getOutputLines().size() - 1);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ls output = " + outputLine);
                }
                if ((outputTokens = new StringTokenizer(outputLine)).countTokens() < 5) {
                    throw new RuntimeIOException("ls -ld " + this.getPath() + " returned output that contains less than the expected 5 tokens: " + outputLine);
                }
                String permissions = outputTokens.nextToken();
                outputTokens.nextToken();
                outputTokens.nextToken();
                outputTokens.nextToken();
                String size = outputTokens.nextToken();
                results.isFile = permissions.length() >= 1 && permissions.charAt(0) == '-';
                results.isDirectory = permissions.length() >= 1 && permissions.charAt(0) == 'd';
                results.canRead = permissions.length() >= 2 && permissions.charAt(1) == 'r';
                results.canWrite = permissions.length() >= 3 && permissions.charAt(2) == 'w';
                results.canExecute = permissions.length() >= 4 && permissions.charAt(3) == 'x';
                try {
                    results.length = Integer.parseInt(size);
                }
                catch (NumberFormatException exc) {
                    this.logger.warn("Cannot parse length of " + this.getPath() + " from ls output: " + outputLine + ". Length will be reported as -1.", (Throwable)exc);
                }
            }
        } else {
            results.exists = false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Listed file " + this + ": exists=" + results.exists + ", isDirectory=" + results.isDirectory + ", length=" + results.length + ", canRead=" + results.canRead + ", canWrite=" + results.canWrite + ", canExecute=" + results.canExecute);
        }
        return results;
    }

    @Override
    public InputStream getInputStream() throws RuntimeIOException {
        this.logger.debug("Opening ssh:scp: input stream to read from file {}", (Object)this);
        try {
            final File tempFile = File.createTempFile("scp_download", ".tmp");
            tempFile.deleteOnExit();
            ((SshScpConnection)this.connection).getSshClient().newSCPFileTransfer().download(this.getPath(), tempFile.getPath());
            return new FileInputStream(tempFile){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        tempFile.delete();
                    }
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot open " + this + " for reading: " + e.toString(), e);
        }
    }

    @Override
    public OutputStream getOutputStream() throws RuntimeIOException {
        this.logger.debug("Opening ssh:scp: output stream to write to file {}", (Object)this);
        try {
            final File tempFile = File.createTempFile("scp_upload", ".tmp");
            tempFile.deleteOnExit();
            return new FileOutputStream(tempFile){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        this.uploadAndDelete(tempFile);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void uploadAndDelete(File tempFile2) throws IOException {
                    try {
                        ((SshScpConnection)SshScpFile.this.connection).getSshClient().newSCPFileTransfer().upload(tempFile2.getPath(), SshScpFile.this.getPath());
                    }
                    finally {
                        tempFile2.delete();
                    }
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot open " + this + " for reading: " + e.toString(), e);
        }
    }

    @Override
    public List<OverthereFile> listFiles() {
        this.logger.debug("Listing directory {}", (Object)this);
        CapturingOverthereProcessOutputHandler capturedOutput = CapturingOverthereProcessOutputHandler.capturingHandler();
        int errno = this.executeCommand(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), capturedOutput), CmdLine.build("ls", "-1", this.getPath()));
        if (errno != 0) {
            throw new RuntimeIOException("Cannot list directory " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        ArrayList files = Lists.newArrayList();
        for (String lsLine : capturedOutput.getOutputLines()) {
            files.add(((SshScpConnection)this.connection).getFile(this, lsLine));
        }
        return files;
    }

    @Override
    public void mkdir() {
        this.logger.debug("Creating directory {}", (Object)this);
        this.mkdir(new String[0]);
    }

    @Override
    public void mkdirs() {
        this.logger.debug("Creating directories {}", (Object)this);
        this.mkdir("-p");
    }

    protected void mkdir(String ... mkdirOptions) throws RuntimeIOException {
        CmdLine commandLine = CmdLine.build("mkdir");
        for (String opt : mkdirOptions) {
            commandLine.addArgument(opt);
        }
        commandLine.addArgument(this.getPath());
        CapturingOverthereProcessOutputHandler capturedOutput = CapturingOverthereProcessOutputHandler.capturingHandler();
        int errno = this.executeCommand(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), capturedOutput), commandLine);
        if (errno != 0) {
            throw new RuntimeIOException("Cannot create directory or -ies " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Created directory " + this + " (with options:" + Joiner.on((char)' ').join((Object[])mkdirOptions));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void renameTo(OverthereFile dest) {
        this.logger.debug("Renaming {} to {}", (Object)this, (Object)dest);
        if (!(dest instanceof SshScpFile)) throw new RuntimeIOException("Cannot rename :ssh:" + ((SshScpConnection)this.connection).sshConnectionType.toString().toLowerCase() + ": file/directory " + this + " to non-:ssh:" + ((SshScpConnection)this.connection).sshConnectionType.toString().toLowerCase() + ": file/directory " + dest);
        SshScpFile sshScpDestFile = (SshScpFile)dest;
        if (sshScpDestFile.getConnection() != this.getConnection()) throw new RuntimeIOException("Cannot rename :ssh:" + ((SshScpConnection)this.connection).sshConnectionType.toString().toLowerCase() + ": file/directory " + this + " to file/directory " + dest + " because it is in a different connection");
        CapturingOverthereProcessOutputHandler capturedOutput = CapturingOverthereProcessOutputHandler.capturingHandler();
        int errno = this.executeCommand(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), capturedOutput), CmdLine.build("mv", this.getPath(), sshScpDestFile.getPath()));
        if (errno == 0) return;
        throw new RuntimeIOException("Cannot rename file/directory " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
    }

    @Override
    public void setExecutable(boolean executable) {
        this.logger.debug("Setting execute permission on {} to {}", (Object)this, (Object)executable);
        CapturingOverthereProcessOutputHandler capturedOutput = CapturingOverthereProcessOutputHandler.capturingHandler();
        int errno = this.executeCommand(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), capturedOutput), CmdLine.build("chmod", executable ? "+x" : "-x", this.getPath()));
        if (errno != 0) {
            throw new RuntimeIOException("Cannot set execute permission on file " + this + " to " + executable + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
    }

    @Override
    protected void deleteDirectory() {
        this.logger.debug("Deleting directory {}", (Object)this);
        CapturingOverthereProcessOutputHandler capturedOutput = CapturingOverthereProcessOutputHandler.capturingHandler();
        int errno = this.executeCommand(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), capturedOutput), CmdLine.build("rmdir", this.getPath()));
        if (errno != 0) {
            throw new RuntimeIOException("Cannot delete directory " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
    }

    @Override
    protected void deleteFile() {
        this.logger.debug("Deleting file {}", (Object)this);
        CapturingOverthereProcessOutputHandler capturedOutput = CapturingOverthereProcessOutputHandler.capturingHandler();
        int errno = this.executeCommand(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), capturedOutput), CmdLine.build("rm", "-f", this.getPath()));
        if (errno != 0) {
            throw new RuntimeIOException("Cannot delete file " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
    }

    @Override
    public void deleteRecursively() throws RuntimeIOException {
        this.logger.debug("Recursively deleting file or directory {}", (Object)this);
        CapturingOverthereProcessOutputHandler capturedOutput = CapturingOverthereProcessOutputHandler.capturingHandler();
        int errno = this.executeCommand(MultipleOverthereProcessOutputHandler.multiHandler(LoggingOverthereProcessOutputHandler.loggingHandler(this.logger), capturedOutput), CmdLine.build("rm", "-rf", this.getPath()));
        if (errno != 0) {
            throw new RuntimeIOException("Cannot recursively delete file or directory " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
    }

    @Override
    protected void copyFrom(OverthereFile source) {
        this.logger.debug("Copying file or directory {} to {}", (Object)source, (Object)this);
        SCPUploadClient uploadClient = ((SshScpConnection)this.connection).getSshClient().newSCPFileTransfer().newSCPUploadClient();
        try {
            if (source.isDirectory() && this.exists()) {
                for (OverthereFile sourceFile : source.listFiles()) {
                    uploadClient.copy((LocalSourceFile)new OverthereFileLocalSourceFile(sourceFile), this.getPath());
                }
            } else {
                uploadClient.copy((LocalSourceFile)new OverthereFileLocalSourceFile(source), this.getPath());
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot copy " + source + " to " + this + ": " + e.toString(), e);
        }
    }

    protected static class OverthereFileLocalSourceFile
    implements LocalSourceFile {
        private OverthereFile f;

        public OverthereFileLocalSourceFile(OverthereFile f) {
            this.f = f;
        }

        public String getName() {
            return this.f.getName();
        }

        public long getLength() {
            return this.f.length();
        }

        public InputStream getInputStream() throws IOException {
            return this.f.getInputStream();
        }

        public int getPermissions() throws IOException {
            return this.f.isDirectory() ? 493 : 420;
        }

        public boolean isFile() {
            return this.f.isFile();
        }

        public boolean isDirectory() {
            return this.f.isDirectory();
        }

        public Iterable<? extends LocalSourceFile> getChildren(LocalFileFilter filter) throws IOException {
            ArrayList files = Lists.newArrayList();
            for (OverthereFile each : this.f.listFiles()) {
                files.add(new OverthereFileLocalSourceFile(each));
            }
            return files;
        }

        public boolean providesAtimeMtime() {
            return false;
        }

        public long getLastAccessTime() throws IOException {
            return 0L;
        }

        public long getLastModifiedTime() throws IOException {
            return 0L;
        }
    }

    public static class LsResults {
        public boolean exists;
        public boolean isFile;
        public boolean isDirectory;
        public long length = -1L;
        public boolean canRead;
        public boolean canWrite;
        public boolean canExecute;
    }
}

