/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.ssh.SshInteractiveSudoPasswordHandlingStream;
import com.xebialabs.overthere.ssh.SshProcess;
import com.xebialabs.overthere.ssh.SshSudoConnection;
import java.io.InputStream;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;

class SshInteractiveSudoConnection
extends SshSudoConnection {
    private String passwordPromptRegex;

    public SshInteractiveSudoConnection(String type, ConnectionOptions options) {
        super(type, options);
        this.passwordPromptRegex = options.get("sudoPasswordPromptRegex", ".*[Pp]assword.*:");
        Preconditions.checkArgument((!this.passwordPromptRegex.endsWith("*") ? 1 : 0) != 0, (Object)"sudoPasswordPromptRegex should not end in a wildcard");
        Preconditions.checkArgument((!this.passwordPromptRegex.endsWith("?") ? 1 : 0) != 0, (Object)"sudoPasswordPromptRegex should not end in a wildcard");
        Preconditions.checkArgument((this.password != null ? 1 : 0) != 0, (Object)("Cannot start a ssh:" + this.sshConnectionType.toString().toLowerCase() + ": connection without a password"));
    }

    @Override
    protected SshProcess createProcess(Session session, CmdLine commandLine) throws TransportException, ConnectionException {
        return new SshProcess(this, this.os, session, commandLine){

            @Override
            public InputStream getStdout() {
                return new SshInteractiveSudoPasswordHandlingStream(super.getStdout(), this.getStdin(), SshInteractiveSudoConnection.this.password, SshInteractiveSudoConnection.this.passwordPromptRegex);
            }
        };
    }
}

