/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Predicate;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class SyntheticHelper {
    SyntheticHelper() {
    }

    static String getRequiredStringAttribute(Element element, String attributeName) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        throw new IllegalArgumentException("Attribute " + attributeName + " not provided");
    }

    static String getRequiredStringAttribute(Element element, String attributeName, String additionalMessage) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        throw new IllegalArgumentException("Attribute " + attributeName + " not provided " + additionalMessage);
    }

    static Type getRequiredTypeAttribute(Element element, String attributeName) {
        Type type = SyntheticHelper.getOptionalTypeAttribute(element, attributeName);
        if (type == null) {
            throw new IllegalArgumentException("Attribute " + attributeName + " not provided");
        }
        return type;
    }

    static Type getOptionalTypeAttribute(Element element, String attributeName, Type defaultValue) {
        String typeAttr = SyntheticHelper.getOptionalStringAttribute(element, attributeName, null);
        Type type = defaultValue;
        if (typeAttr != null) {
            type = Type.valueOf(typeAttr);
        }
        return type;
    }

    static Type getOptionalTypeAttribute(Element element, String attributeName) {
        return SyntheticHelper.getOptionalTypeAttribute(element, attributeName, null);
    }

    static boolean getOptionalBooleanAttribute(Element element, String attributeName, boolean defaultValue) {
        return Boolean.valueOf(SyntheticHelper.getOptionalStringAttribute(element, attributeName, Boolean.toString(defaultValue)));
    }

    static String getOptionalStringAttribute(Element element, String attributeName, String defaultValue) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        return defaultValue;
    }

    static Iterator<Element> iterateChildElementsByName(final Element element, final Predicate<String> matcher) {
        return new Iterator<Element>(){
            private int i = 0;
            private NodeList childNodes = element.getChildNodes();
            private int nextIndex = 0;

            @Override
            public boolean hasNext() {
                if (this.nextIndex == this.i) {
                    this.nextIndex = this.findNext();
                }
                return this.nextIndex > this.i;
            }

            @Override
            public Element next() {
                if (this.nextIndex == this.i) {
                    this.nextIndex = this.findNext();
                }
                if (this.nextIndex < this.i) {
                    throw new NoSuchElementException("There are no more matching elements");
                }
                this.i = this.nextIndex;
                return (Element)this.childNodes.item(this.i);
            }

            private int findNext() {
                int next = this.i;
                while (next < this.childNodes.getLength()) {
                    Element e;
                    if (!(this.childNodes.item(++next) instanceof Element) || !matcher.apply((Object)(e = (Element)this.childNodes.item(next)).getNodeName())) continue;
                    return next;
                }
                return this.i - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static <E> void forEach(Iterator<E> iterator, Closure<E> closure) {
        while (iterator.hasNext()) {
            closure.call(iterator.next());
        }
    }

    public static interface Closure<E> {
        public void call(E var1);
    }
}

