/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.deployment.execution;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.execution.InterleavedPlan;
import com.xebialabs.deployit.plugin.api.deployment.execution.ParallelPlan;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plan;
import com.xebialabs.deployit.plugin.api.deployment.execution.SerialPlan;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import java.util.List;

public class Plans {
    public static InterleavedPlan interleaved(Delta ... operations) {
        return new InterleavedPlan(operations);
    }

    public static ParallelPlan parallel(Plan ... plans) {
        return new ParallelPlan(plans);
    }

    public static ParallelPlan parallel(List<Plan> plans) {
        return new ParallelPlan(plans);
    }

    public static SerialPlan serial(Plan ... plans) {
        return new SerialPlan(plans);
    }

    public static SerialPlan serial(List<Plan> plans) {
        return new SerialPlan(plans);
    }

    public static InterleavedPlan interleaved(ListMultimap<Integer, DeploymentStep> steps) {
        return new InterleavedPlan(Lists.newArrayList(), steps);
    }

    public static InterleavedPlanBuilder newInterleavedPlan(InterleavedPlan original) {
        return new InterleavedPlanBuilder(original);
    }

    public static class InterleavedPlanBuilder {
        private List<Delta> operations;
        private ListMultimap<Integer, DeploymentStep> steps;

        private InterleavedPlanBuilder(InterleavedPlan original) {
            this.operations = original.getDeltas();
            this.steps = ArrayListMultimap.create(original.getStepsMap());
        }

        public InterleavedPlanBuilder withStep(DeploymentStep step) {
            this.steps.put((Object)step.getOrder(), (Object)step);
            return this;
        }

        public InterleavedPlanBuilder withSteps(List<DeploymentStep> steps) {
            for (DeploymentStep step : steps) {
                this.steps.put((Object)step.getOrder(), (Object)step);
            }
            return this;
        }

        public InterleavedPlanBuilder withSteps(DeploymentStep ... steps) {
            for (DeploymentStep step : steps) {
                this.steps.put((Object)step.getOrder(), (Object)step);
            }
            return this;
        }

        public InterleavedPlanBuilder replaceAllSteps(ListMultimap<Integer, DeploymentStep> steps) {
            this.steps = steps;
            return this;
        }

        public InterleavedPlan build() {
            return new InterleavedPlan(this.operations, this.steps);
        }
    }
}

